package ru.yandex.autotests.directapi.stat.getkeywordintersection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayWithSize;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.KeywordIntersectionResponse;
import ru.yandex.autotests.directapi.matchers.KeywordMatcher;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordIntersectionRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.arrayContainingInAnyOrder;

/**
 * User: ginger
 * Date: 12.04.13
 *
 * https://jira.yandex-team.ru/browse/DIRECT-20605
 */

@Aqua.Test
@Features(StatFeatures.GET_KEYWORDS_INTERSECTION)
@RunWith(Parameterized.class)
public class GetKeywordsIntersectionTest {
    public static String CLIENT = Logins.CLIENT_FREE_YE_DEFAULT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class).as(Logins.AGENCY_YE_DEFAULT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static String white = "белый";
    private static String whited = "белого";
    private static String red = "красный";
    private static String reded = "красного";

    private static int campaignWithKeywordBlackId = createCampaignWithTextPhrase(red);
    private static int campaignWithKeywordBlackedId = createCampaignWithTextPhrase(reded);
    private static int campaignWithKeywordWhiteId = createCampaignWithTextPhrase(white);
    private static int campaignWithKeywordWhitedId = createCampaignWithTextPhrase(whited);

    public static int createCampaignWithTextPhrase(String keyword) {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, CLIENT);
        api.userSteps.keywordsSteps().addKeyword(CLIENT, adGroupId, keyword);
        return campaignId.intValue();
    }

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.AGENCY_YE_DEFAULT);
    }

    @Parameterized.Parameters
    public static Collection reportRequests() {
        List<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{
                new String[]{red, reded, white},
                null,
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordWhitedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithNoID(red),
                                        KeywordMatcher.hasKeywordWithNoID(reded)),
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithNoID(white),
                                        KeywordMatcher.hasKeywordWithID(white),
                                        KeywordMatcher.hasKeywordWithID(whited)
                                ))),
        });
        params.add(new Object[]{
                new String[]{red, reded},
                null,
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordWhitedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithNoID(red),
                                        KeywordMatcher.hasKeywordWithNoID(reded))
                        ))
        });
        params.add(new Object[]{
                new String[]{red, reded, white},
                null,
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordBlackedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithNoID(red),
                                        KeywordMatcher.hasKeywordWithNoID(reded),
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithID(reded))))
        });
        params.add(new Object[]{
                new String[]{red, whited},
                null,
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordBlackedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithNoID(red),
                                        KeywordMatcher.hasKeywordWithID(reded))))
        });
        params.add(new Object[]{
                new String[]{whited},
                null,
                new int[]{campaignWithKeywordBlackId},
                IsArrayWithSize.emptyArray()
        });
        params.add(new Object[]{
                new String[]{red, reded, white},
                null,
                null,
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithNoID(red),
                                        KeywordMatcher.hasKeywordWithNoID(reded))))
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordBlackedId, campaignWithKeywordWhiteId},
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordWhitedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(white),
                                        KeywordMatcher.hasKeywordWithID(white),
                                        KeywordMatcher.hasKeywordWithID(whited))))
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordBlackedId},
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordWhitedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithID(reded))))
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordBlackedId, campaignWithKeywordWhiteId},
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordBlackedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithID(reded),
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithID(reded))))
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordWhiteId},
                new int[]{campaignWithKeywordBlackId, campaignWithKeywordBlackedId},
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithID(red),
                                        KeywordMatcher.hasKeywordWithID(reded))))
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordBlackId},
                new int[]{campaignWithKeywordWhiteId},
                IsArrayWithSize.emptyArray()
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordWhitedId, campaignWithKeywordBlackId},
                null,
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(white),
                                        KeywordMatcher.hasKeywordWithID(whited))))
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordBlackId},
                null,
                IsArrayWithSize.emptyArray()
        });
        params.add(new Object[]{
                null,
                new int[]{campaignWithKeywordWhiteId, campaignWithKeywordWhitedId},
                null,
                allOf(
                        arrayContainingInAnyOrder(
                                arrayContainingInAnyOrder(
                                        KeywordMatcher.hasKeywordWithID(white),
                                        KeywordMatcher.hasKeywordWithID(whited))))
        });
        return params;
    }

    @Parameterized.Parameter(value = 0)
    public String[] keywords;

    @Parameterized.Parameter(value = 1)
    public int[] campaignIDs;

    @Parameterized.Parameter(value = 2)
    public int[] withCampaignIDs;

    @Parameterized.Parameter(value = 3)
    public Matcher responseMatcher;


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7298")
    public void intersectionKeywords() {
        KeywordIntersectionRequestMap keywordsIntersection = new KeywordIntersectionRequestMap(api.type())
                .withKeywords(keywords)
                .withCampaignIDS(campaignIDs)
                .withWithCampaignIDS(withCampaignIDs);
        KeywordIntersectionResponse keywordsResponse = api.userSteps.statisticsSteps()
                .getKeywordsIntersection(keywordsIntersection);

        assertThat("Неправильно пересеклись слова", keywordsResponse.getIntersectingKeywords(), responseMatcher);
    }

 }
