package ru.yandex.autotests.directapi.stat.getkeywordssuggestion;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordsSuggestionInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;


import java.util.Arrays;
import java.util.Collection;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;

@Aqua.Test
@Features(StatFeatures.GET_KEYWORD_SUGGESTION)
@RunWith(Parameterized.class)
public class GetKeywordsSuggestionAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CLIENT_FREE_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.AGENCY_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.MANAGER_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.SUPPORT);
    }

    @Parameterized.Parameters
    public static Collection roleValues() {
        return Arrays.asList(new Object[][]{
                {Logins.SUPER_LOGIN},
                {Logins.SUPER_READER},
                {Logins.SUPPORT},
                {Logins.PLACER},
                {Logins.MEDIA},
                {Logins.AGENCY_YE_DEFAULT},
                {Logins.MANAGER_DEFAULT},
                {Logins.CLIENT_FREE_YE_DEFAULT}

        });
    }

    @Parameterized.Parameter
    public String operator;


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7299")
    public void getKeywordsSuggestion() {
        KeywordsSuggestionInfoMap keywordsSuggestionInfoMap = new KeywordsSuggestionInfoMap(api.type())
                .withKeywords("стол", "продажа стульев");
        String[] suggestions = api.as(Logins.SUPER_LOGIN,operator)
                .userSteps.statisticsSteps().getKeywordSuggestion(keywordsSuggestionInfoMap);
        assertThat("Неверный список подсказок", suggestions.length, allOf(greaterThan(0), lessThanOrEqualTo(20)));
    }
}
