package ru.yandex.autotests.directapi.stat.getkeywordssuggestion;


import org.apache.commons.lang.RandomStringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;
import ru.yandex.autotests.directapi.model.statistics.KeywordsSuggestionInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.directapi.utils.ErrorTextUtils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

@Aqua.Test
@Features(StatFeatures.GET_KEYWORD_SUGGESTION)
public class GetKeywordsSuggestionRequestValidateTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_WORDSTAT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_WORDSTAT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7300")
    public void expectErrorWhenGetKeywordsSuggestionWithLongPhrase() {
        String longWord = RandomStringUtils.randomAlphabetic(BannerInfoMap.MAX_KEYWORD_LENGTH + 1);
        KeywordsSuggestionInfoMap keywordsSuggestionInfoMap = new KeywordsSuggestionInfoMap(api.type())
                .withKeywords(longWord);
        api.userSteps.statisticsSteps().shouldGetErrorOn(
                Method.GET_KEYWORDS_SUGGESTION,
                keywordsSuggestionInfoMap,
                new AxisError(71,
                        AxisErrorDetails.KEYWORDSSUGGESTIONINFO_KEYWORD_LENGTH_EXCEEDED
                        , ErrorTextUtils.getShortTextParameter(longWord)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7301")
    public void expectErrorWhenGetKeywordsSuggestionWithNull() {
        KeywordsSuggestionInfoMap keywordsSuggestionInfoMap = new KeywordsSuggestionInfoMap(api.type());
        api.userSteps.statisticsSteps().shouldGetErrorOn(
                Method.GET_KEYWORDS_SUGGESTION,
                keywordsSuggestionInfoMap,
                new AxisError(71,AxisErrorDetails.FIELD_MUST_NOT_BE_EMPTY,
                        capitalize(KeywordsSuggestionInfoMap.KEYWORDS)));
    }
}
