package ru.yandex.autotests.directapi.stat.getkeywordssuggestion;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.model.statistics.KeywordsSuggestionInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;

/**
 * Created by chicos on 11.03.14.
 * https://jira.yandex-team.ru/browse/TESTIRT-1595
 */
@Aqua.Test
@Features(StatFeatures.GET_KEYWORD_SUGGESTION)
@Stories(ApiStories.SHARDING)
public class GetKeywordsSuggestionShardingTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String clientShard2 = StatLogins.CLIENT_FORECAST_SHARD_2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(clientShard2);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void reshardUser(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CLIENT_FORECAST_SHARD_2);
        api.userSteps.clientFakeSteps().reshardUserWithLock(StatLogins.CLIENT_FORECAST_SHARD_2, ShardNumbers.EXTRA_SHARD);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7302")
    public void getKeywordsSuggestionShardedTest() {
        String[] suggestions = api.userSteps.statisticsSteps().getKeywordSuggestion(
                new KeywordsSuggestionInfoMap(api.type())
                        .withKeywords("стол", "продажа стульев")
        );
        assertThat("Неверный список подсказок", suggestions.length, allOf(greaterThan(0), lessThanOrEqualTo(20)));
    }
}
