package ru.yandex.autotests.directapi.stat.getkeywordssuggestion;


import org.hamcrest.Matcher;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordsSuggestionInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


import java.util.Arrays;
import java.util.Collection;
import static org.hamcrest.Matchers.*;

@Aqua.Test
@Features(StatFeatures.GET_KEYWORD_SUGGESTION)
@RunWith(Parameterized.class)
public class GetKeywordsSuggestionTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_WORDSTAT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameter(value = 0)
    public String[] words;

    @Parameterized.Parameter(value = 1)
    public Matcher sizeMatcher;

    @Parameterized.Parameters
    public static Collection reportRequests() {
        Object[][] params = new Object[][]{
                {new String[]{"продажа стульев"}, allOf(greaterThan(0), lessThanOrEqualTo(20))},
                {new String[]{"стол", "продажа стульев"}, allOf(greaterThan(0), lessThanOrEqualTo(20))},
                {new String[]{"стол", ""}, allOf(greaterThan(0), lessThanOrEqualTo(20))},
                {new String[]{""}, equalTo(0)},
                {new String[]{}, equalTo(0)}
        };
        return Arrays.asList(params);
    }

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_WORDSTAT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7303")
    public void getKeywordsSuggestionWithKeywords() {
        KeywordsSuggestionInfoMap keywordsSuggestionInfoMap = new KeywordsSuggestionInfoMap(api.type())
                .withKeywords(words);
        String[] suggestions = api.userSteps.statisticsSteps().getKeywordSuggestion(keywordsSuggestionInfoMap);
        TestSteps.assertThat("список подсказок корректен", suggestions.length, sizeMatcher);
    }
}
