package ru.yandex.autotests.directapi.stat.getkeywordssuggestion;


import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45.ClientsUnitInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordsSuggestionInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.statistics.StatisticsSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;

@Aqua.Test
@Features(StatFeatures.GET_KEYWORD_SUGGESTION)
@RunWith(Parameterized.class)
public class GetKeywordsSuggestionUnitsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String clientLogin = StatLogins.GET_KEYWORDS_SUGGESTION_UNITS;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(Logins.SUPER_LOGIN, clientLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters
    public static Collection reportRequests() {
        List<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{new String[]{"продажа стульев"}, 1});
        params.add(new Object[]{new String[]{"продажа", "стульев"}, 2});
        params.add(new Object[]{new String[]{"стол", ""}, 1});
        params.add(new Object[]{new String[]{""}, 0});
        params.add(new Object[]{new String[]{}, 0});
        params.add(new Object[]{new String[]{"dfgdsfgdsfg"}, 1});
        return params;
    }

    @Parameterized.Parameter
    public String[] words;

    @Parameterized.Parameter(value = 1)
    public int costWordsCount;

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7304")
    public void getKeywordsSuggestionOneWordCost() {
        int unitsBefore = ((ClientsUnitInfo)api.userSteps.clientSteps().getClientUnits(clientLogin)).getUnitsRest();

        KeywordsSuggestionInfoMap keywordsSuggestionInfoMap = new KeywordsSuggestionInfoMap(api.type())
                .withKeywords(words);
        api.userSteps.statisticsSteps().getKeywordSuggestion(keywordsSuggestionInfoMap);
        int unitsAfter = ((ClientsUnitInfo)api.userSteps.clientSteps().getClientUnits(clientLogin)).getUnitsRest();
        assertThat("Неверное количество оставшихся баллов", unitsAfter,
                equalTo(unitsBefore - StatisticsSteps.GET_KEYWORDS_SUGGESTION_COST_PER_WORD * costWordsCount));
    }
}
