package ru.yandex.autotests.directapi.stat.getkeywordssuggestion;


import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.statistics.KeywordsSuggestionInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.*;

@Aqua.Test
@Features(StatFeatures.GET_KEYWORD_SUGGESTION)
@RunWith(Parameterized.class)
public class GetKeywordsSuggestionVersionTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN, StatLogins.CREATE_NEW_WORDSTAT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);


    @Parameterized.Parameters
    public static Collection reportRequests() {
        List<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{4});
        params.add(new Object[]{104});
        return params;
    }

    @Parameterized.Parameter
    public int version;

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_WORDSTAT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7305")
    public void getKeywordsSuggestion() {
        KeywordsSuggestionInfoMap keywordsSuggestionInfoMap = new KeywordsSuggestionInfoMap(api.type())
                .withKeywords("стол", "продажа стульев");
        String[] suggestions = api.version(version)
                .userSteps.statisticsSteps().getKeywordSuggestion(keywordsSuggestionInfoMap);
        assertThat("Неверный список подсказок", suggestions.length, allOf(greaterThan(0), lessThanOrEqualTo(20)));
    }
}
