package ru.yandex.autotests.directapi.stat.getwordstatsync;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;

/**
 * User: mariabye
 * Date: 30.10.12
 *
 * метод недоступен в версии 4 и для клиентов и агентств
 */
@Aqua.Test
@Features(StatFeatures.GET_WORDSTAT_SYNC)
public class GetWordstatSyncByNoAllowedRolesTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @BeforeClass
    public static void enableAPI(){
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CLIENT_FREE_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.AGENCY_YE_DEFAULT);
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.MANAGER_DEFAULT);
    }

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    public static NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
            .withPhrases("магазин -интернет");

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7328")
    public void getWordstatSyncByClient() {
        api.version(104).as(Logins.CLIENT_FREE_YE_DEFAULT).userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_WORDSTAT_SYNC,
                reportInfo,
                new AxisError(510, null));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7327")
    public void getWordstatSyncByAgency()  {
        api.version(104).as(Logins.AGENCY_YE_DEFAULT).userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_WORDSTAT_SYNC,
                reportInfo,
                new AxisError(510, null));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7329")
    public void getWordstatSyncByManagerInOldVersion() {
        api.version(4).as(Logins.MANAGER_DEFAULT).userSteps.forecastSteps().shouldGetErrorOn(
                Method.GET_WORDSTAT_SYNC,
                reportInfo,
                new AxisError(509, null));
    }
}
