package ru.yandex.autotests.directapi.stat.model;

import com.google.gson.annotations.SerializedName;
import ru.yandex.autotests.directapi.darkside.exceptions.DarkSideException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by buhter on 08/09/15.
 */
public class GetSearchQueryReportResponse {
    List<ReportLine> reportLines;

    public static class ReportLine {
        @SerializedName("StatDate")
        String statDate;
        @SerializedName("CampaignId")
        Long campaignId;
        @SerializedName("AdGroupId")
        Long adGroupId;
        @SerializedName("KeywordId")
        Long keywordId;
        @SerializedName("Impressions")
        Integer Impressions;
        @SerializedName("Clicks")
        Integer Clicks;
        @SerializedName("Sum")
        Double sum;
        @SerializedName("Broadmatch")
        String broadmatch;
        @SerializedName("SearchQuery")
        String searchQuery;

        public String getStatDate() {
            return statDate;
        }

        public void setStatDate(String statDate) {
            this.statDate = statDate;
        }

        public Long getCampaignId() {
            return campaignId;
        }

        public void setCampaignId(Long campaignId) {
            this.campaignId = campaignId;
        }

        public Long getAdGroupId() {
            return adGroupId;
        }

        public void setAdGroupId(Long adGroupId) {
            this.adGroupId = adGroupId;
        }

        public Long getKeywordId() {
            return keywordId;
        }

        public void setKeywordId(Long keywordId) {
            this.keywordId = keywordId;
        }

        public Integer getImpressions() {
            return Impressions;
        }

        public void setImpressions(Integer impressions) {
            Impressions = impressions;
        }

        public Integer getClicks() {
            return Clicks;
        }

        public void setClicks(Integer clicks) {
            Clicks = clicks;
        }

        public Double getSum() {
            return sum;
        }

        public void setSum(Double sum) {
            this.sum = sum;
        }

        public String getBroadmatch() {
            return broadmatch;
        }

        public void setBroadmatch(String broadmatch) {
            this.broadmatch = broadmatch;
        }

        public String getSearchQuery() {
            return searchQuery;
        }

        public void setSearchQuery(String searchQuery) {
            this.searchQuery = searchQuery;
        }

        @Override
        public String toString() {
            return JsonUtils.toString(this);
        }
    }

    public GetSearchQueryReportResponse(String tsv) {
        reportLines = new ArrayList<>();
        String[] tsvLines = tsv.replace("\r", "").split("\n");
        Pattern pattern = Pattern.compile("(.*)\t(\\d+)\t(\\d+)\t(\\d*)\t(\\d+)\t(\\d+)\t(\\d?.+)\t(.*)\t(.*)");
        for (String line : tsvLines) {
            if ((line != null) && !line.startsWith("StatDate")) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    ReportLine reportLine = new ReportLine();
                    reportLine.setStatDate(matcher.group(1));
                    reportLine.setCampaignId(Long.valueOf(matcher.group(2)));
                    reportLine.setAdGroupId(Long.valueOf(matcher.group(3)));
                    reportLine.setKeywordId(matcher.group(4).equals("") ? null : Long.valueOf(matcher.group(4)));
                    reportLine.setImpressions(Integer.valueOf(matcher.group(5)));
                    reportLine.setClicks(Integer.valueOf(matcher.group(6)));
                    reportLine.setSum(Double.valueOf(matcher.group(7)));
                    reportLine.setBroadmatch(matcher.group(8));
                    reportLine.setSearchQuery(matcher.group(9));
                    reportLines.add(reportLine);
                } else
                    throw new DarkSideException("Ошибка парсинга ответа: не удалось распарсить строку " + line);
            }
        }
    }

    public List<ReportLine> getReportLines() {
        return reportLines;
    }


}
