package ru.yandex.autotests.directapi.stat.production;

import java.util.Arrays;
import java.util.List;

import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;

/**
 * Created by chicos on 28.04.14.
 * <p/>
 * Smoke-тесты на проверку некоторых методов на production окружении
 * https://jira.yandex-team.ru/browse/TESTIRT-1800
 */
@Aqua.Test
@Features(ApiFeatures.PRODUCTION)
@Stories(StatFeatures.CREATE_NEW_WORDSTAT)
public class CreateNewWordstatProdTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    private static String clientLogin = Logins.CLIENT_SMOKE_PROD;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104).as(clientLogin);

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7343")
    public void wordstatReportWithFewPhrases() {
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("новогодние подарки",
                        "плазменный резак",
                        "кролики"
                );
        log.info("Вызываем метод CreateNewWordstatReport с двумя фразами");
        List<String> gotPhrases = api.userSteps.forecastSteps().getWordstatReportPhrases(reportInfo);
        Assert.assertThat("Неправильный порядок фраз в отчете",
                gotPhrases,
                IsEqual.equalTo(Arrays.asList(reportInfo.getPhrases()))
        );
    }

    @After
    public void deleteReportsManually() {
        api.userSteps.forecastSteps().deleteWordstatReports();
    }
}
