package ru.yandex.autotests.directapi.stat.rearrangekeywords;


import org.apache.commons.lang.RandomStringUtils;
import org.junit.ClassRule;
import org.junit.Test;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.banners.BannerInfoMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.statistics.RearrangeKeywordsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.directapi.utils.ErrorTextUtils;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * User: ginger
 * Date: 19.09.13
 * <p>
 * https://jira.yandex-team.ru/browse/DIRECT-24203
 */

@Aqua.Test
@Features(StatFeatures.REARRANGE_KEYWORDS)
public class RearrangeKeywordsRequestTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().wsdl(APIPort_PortType.class);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7346")
    public void tryCallMethodWithEmptyKeywordsShouldBeError() {
        RearrangeKeywordsRequestMap request = new RearrangeKeywordsRequestMap(
                api.version(104).wsdl(APIPort_PortType.class).type());
        request.withKeywords(new String[]{});
        request.withAutoMinusWords(Value.NO);
        api.as(Logins.SUPER_LOGIN, StatLogins.BOOKING_COM_AGENCY)
                .userSteps.statisticsSteps().shouldGetErrorOn(
                Method.REARRANGE_KEYWORDS,
                request,
                new AxisError(30, AxisErrorDetails.THE_ARRAY_CANNOT_BE_EMPTY,
                        capitalize(RearrangeKeywordsRequestMap.KEYWORDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7347")
    public void tryCallMethodWithKeywordsMinusSameKeywordsShouldBeError() {
        RearrangeKeywordsRequestMap request = new RearrangeKeywordsRequestMap(
                api.version(104).wsdl(APIPort_PortType.class).type());
        request.withKeywords("слон -слон");
        request.withAutoMinusWords(Value.YES);
        api.as(Logins.SUPER_LOGIN, StatLogins.BOOKING_COM_AGENCY).userSteps.statisticsSteps().shouldGetErrorOn(
                Method.REARRANGE_KEYWORDS,
                request,
                new AxisError(
                        71,
                        AxisErrorDetails.YOU_CANNOT_USE_WORDS_OF_SOURCE_KEYWORD_PHRASE_AS_NEGATIVE_KEYWORDS,
                        "слон", "слон -слон"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7348")
    public void tryCallMethodIn4VersionShouldBeError() {
        RearrangeKeywordsRequestMap request = new RearrangeKeywordsRequestMap(
                api.version(104).wsdl(APIPort_PortType.class).type());
        request.withKeywords("слон -слониха");
        request.withAutoMinusWords(Value.YES);
        api.version(4).as(Logins.SUPER_LOGIN, StatLogins.BOOKING_COM_AGENCY).userSteps.statisticsSteps().shouldGetErrorOn(
                Method.REARRANGE_KEYWORDS,
                request,
                new AxisError(
                        509,
                        null));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7349")
    public void tryCallMethodNotByAppIdNotFromWhitelistShouldBeError() {
        api.userSteps.clientFakeSteps().enableAPI(StatLogins.CREATE_NEW_FORECAST_LOGIN);
        RearrangeKeywordsRequestMap request = new RearrangeKeywordsRequestMap(
                api.version(104).wsdl(APIPort_PortType.class).type());
        request.withKeywords("слон -слоник");
        request.withAutoMinusWords(Value.YES);
        api.as(StatLogins.CLIENT_WITH_OTHER_APP_ID)
                .userSteps.statisticsSteps()
                .shouldGetErrorOn(
                        Method.REARRANGE_KEYWORDS,
                        request,
                        new AxisError(
                                510,
                                null));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7350")
    public void tryCallMethodWithKeywordsOverLimitShouldBeError() {
        RearrangeKeywordsRequestMap request = new RearrangeKeywordsRequestMap(
                api.version(104).wsdl(APIPort_PortType.class).type());
        String keywords = RandomStringUtils.randomAlphabetic(4097);
        request.withKeywords(keywords);
        request.withAutoMinusWords(Value.YES);
        api.as(Logins.SUPER_LOGIN, StatLogins.BOOKING_COM_AGENCY).userSteps.statisticsSteps()
                .shouldGetErrorOn(
                        Method.REARRANGE_KEYWORDS,
                        request,
                        new AxisError(
                                71,
                                AxisErrorDetails.THE_MAXIMUM_STRING_LENGTH_OF_N_CHARACTERS_IN_THE_KEYWORD_PHRASE,
                                BannerInfoMap.MAX_KEYWORD_LENGTH, ErrorTextUtils.getShortTextParameter(keywords)));
    }
}
