package ru.yandex.autotests.directapi.stat.rearrangekeywords;


import org.apache.commons.lang.RandomStringUtils;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.steps.banners.KeywordPhraseGenerator;
import ru.yandex.autotests.directapi.steps.banners.KeywordsSteps;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.RearrangeKeywordsResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.model.statistics.RearrangeKeywordsRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasItems;

/**
 * User: ginger
 * Date: 19.09.13
 *
 * https://jira.yandex-team.ru/browse/DIRECT-24203
 */

@Aqua.Test
@Features(StatFeatures.REARRANGE_KEYWORDS)
@RunWith(Parameterized.class)
public class RearrangeKeywordsTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps()
            .version(104)
            .wsdl(APIPort_PortType.class)
            .as(Logins.SUPER_LOGIN, StatLogins.BOOKING_COM_AGENCY);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Parameterized.Parameters(name = "Request: {0}")
    public static Collection reportRequests() {
        List<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{
                new String[]{"слон лесной",
                "слон",
                "слон зеленый",
                "слон !зелен",
                "слон красный",
                "[слон красен]",
                "слон синий"},
                new String[]{"слон лесной",
                        "слон",
                        "слон зеленый",
                        "слон !зелен",
                        "слон красный",
                        "[слон красен]",
                        "слон синий"}
        });

        params.add(new Object[]{
                new String[]{
                        "слон красный",
                        "[слон красен]",
                        "[слон красен]"
                },
                new String[]{
                        "слон красный",
                        "[слон красен]"
                }
        });
           /*
        params.add(new Object[]{
                new String[]{  //так было у Лены в оригинальном тесте. баг?
                        "слон зеленый",
                        "!зеленом +в слон"
                },
                new String[]{
                        "слон зеленый -!в",
                        "!зеленом +в слон"
                }
        });
           //https://jira.yandex-team.ru/browse/DIRECT-24922
          */


        params.add(new Object[]{
                new String[]{
                        "слон зеленом",
                        "слон в зеленом",
                        "зеленые слоны",
                        "зеленый слон"
                },
                new String[]{
                        "слон зеленом"
                }
        });

        params.add(new Object[]{
                new String[]{
                        "слон зеленом",
                        "зеленый слон синий"
                },
                new String[]{
                        "слон зеленом",
                        "зеленый слон синий"
                }
        });

        KeywordPhraseGenerator keywordPhraseGenerator =
                new KeywordPhraseGenerator(KeywordsSteps.CYRILLIC_CHARS_NO_SPACE, String.CASE_INSENSITIVE_ORDER);

        String phrase = keywordPhraseGenerator
                .generatePhraseOfSpecificLength(
                        new Integer[]{KeywordsSteps.ACCEPTABLE_KEYWORD_LENGTH},
                        KeywordsSteps.PHRASE_MAX_LENGTH,
                        KeywordsSteps.ACCEPTABLE_KEYWORD_LENGTH)
                .toStringWithOrderedWords();

        params.add(new Object[]{
                new String[]{
                        phrase
                },
                new String[]{
                        phrase
                }
        });
        return params;
    }

    @Parameterized.Parameter
    public String[] keywords;

    @Parameterized.Parameter(value = 1)
    public String[] responseKeywords;


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("7351")
    public void callJsonWithDifferentFormsOfKeywordsShouldBeCorrectResponse() {

        RearrangeKeywordsRequestMap request = new RearrangeKeywordsRequestMap(api.type());
        request.withKeywords(keywords)
        .withAutoMinusWords(Value.NO);
        RearrangeKeywordsResponse response = api.userSteps.statisticsSteps().rearrangeKeywords(request);
        assertThat("Неверный список слов в отчете",Arrays.asList(response.getKeywords()),hasItems(responseKeywords));
    }
}
