package ru.yandex.autotests.directapi.stat.smoke;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.common.api45.GetForecastInfo;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewForecastInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 06.08.12
 * Time: 10:54
 * To change this template use File | Settings | File Templates.
 */
@Aqua.Test
@Features(StatFeatures.STAT_MONITOR)
@Stories(StatFeatures.CREATE_NEW_FORECAST)
public class CreateForecastSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = StatLogins.CREATE_NEW_FORECAST_SMOKE;
    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104)
            .as(Logins.SUPER_LOGIN, login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Before
    public void deleteForecastReports(){
        api.as(Logins.SUPER_LOGIN, login).userSteps.forecastSteps().deleteForecastReports();
    }

    @Test
    @Title("Получение прогноза по словам")
    @ru.yandex.qatools.allure.annotations.TestCaseId("7390")
    public void couldCreateNewForecast() {
        NewForecastInfoMap newForecastInfoMap = new NewForecastInfoMap(api.type());
        newForecastInfoMap.withGeoID(1);
        newForecastInfoMap.withPhrases("новогодние подарки");
        newForecastInfoMap.withCategories(new int[0]);
        newForecastInfoMap.withCurrency(Currency.RUB.value());
        log.info("Вызываем метод CreateNewForecast с одной фразой");
        try {
            GetForecastInfo getForecastInfo = api.userSteps.forecastSteps().getForecast(newForecastInfoMap);
            log.info("Прогноз получен");
        } catch (Exception e) {
            throw new DirectAPIException("Не работает отчет прогноза для фраз (forecast)", e);
        }

    }
}

