package ru.yandex.autotests.directapi.stat.smoke;

import org.junit.*;
import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.stat.StatFeatures;
import ru.yandex.autotests.directapi.stat.StatLogins;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.autotests.directapi.common.api45.WordstatReportInfo;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.forecast.NewWordstatReportInfoMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.Title;
import ru.yandex.qatools.hazelcast.SemaphoreRule;
import ru.yandex.terra.junit.rules.BottleMessageRule;

/**
 * User: mariabye
 * Date: 06.08.12
 */
@Aqua.Test
@Features(StatFeatures.STAT_MONITOR)
@Stories(StatFeatures.CREATE_NEW_WORDSTAT)
public class CreateWordstatSmokeTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    static String login = StatLogins.CREATE_NEW_WORDSTAT_SMOKE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(104)
            .as(Logins.SUPER_LOGIN, login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Rule
    public BottleMessageRule bmr = new BottleMessageRule();

    @Before
    public void deleteWordstatReports() {
        api.as(Logins.SUPER_LOGIN, login).userSteps.forecastSteps().deleteWordstatReports();
    }

    @Test
    @Title("Получение отчета wordstat")
    @ru.yandex.qatools.allure.annotations.TestCaseId("7392")
    public void couldCreateNewWordstat() {
        NewWordstatReportInfoMap reportInfo = new NewWordstatReportInfoMap(api.type())
                .withGeoID(1)
                .withPhrases("новогодние подарки");
        WordstatReportInfo[] reports = api.userSteps.forecastSteps().getWordstatReport(reportInfo);
        log.info("Отчет получен");
    }
}

