package ru.yandex.autotests.directapi;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.autotests.balance.lib.environment.Environment;
import ru.yandex.autotests.direct.utils.config.StageType;
import ru.yandex.autotests.direct.utils.config.balancesimple.BalanceSimpleEnvironment;
import ru.yandex.autotests.direct.utils.converter.BetaPortConverter;
import ru.yandex.autotests.direct.utils.converter.BillingEnvironmentConverter;
import ru.yandex.autotests.direct.utils.converter.ListConverter;
import ru.yandex.autotests.direct.utils.converter.StageTypeConverter;
import ru.yandex.autotests.directapi.apiclient.config.ApiLocale;
import ru.yandex.autotests.directapi.apiclient.config.AuthType;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
import ru.yandex.qatools.properties.annotations.Use;
import ru.yandex.qatools.properties.converters.EnumConverter;

/**
 * User: mariabye
 * Date: 15.08.11
 */
@Deprecated
@Resource.Classpath("directapi.properties")
public class DirectApiProperties {

    public DirectApiProperties() {
        PropertyLoader.populate(this);
    }

    /**
     * Определяет стенд, на котором запускаются тесты.
     * Для режима Beta требуется также указать ее номер
     */
    @Use(StageTypeConverter.class)
    @Property("api.stageType")
    protected StageType stageType = StageType.TC;

    @Use(BetaPortConverter.class)
    @Property("api.stageType")
    protected Integer betaPort;

    /**
     * Если свойство задано, то его значение переопределяет
     * дефолтный адрес сервиса, определяемый в StageType
     */
    @Property("api.baseURL")
    protected String baseURL = null;

    /**
     * Версия API, которая будет использована по умолчанию
     */
    @Property("api.currentVersion")
    protected int currentVersion = 104;

    /**
     * Способ авторизации по умолчанию
     */
    @Use(EnumConverter.class)
    @Property("api.defaultAuthType")
    protected AuthType defaultAuthType = AuthType.TOKEN;

    /**
     * Клиент для запросов в Direct по умолчанию (soap или json)
     */
    @Use(EnumConverter.class)
    @Property("api.defaultProtocol")
    protected ProtocolType defaultProtocol = ProtocolType.JSON;

    /**
     * Язык на котором приходят сообщения об ошибках
     */
    @Property("api.header.locale")
    protected String locale = "EN";


    /**
     * Формат URL для запросов к сервису
     */
    @Property("api.useNewUrlFormat")
    protected boolean useNewUrlFormat = true;

    /**
     * Логин, под которой выполняются тесты по умолчанию
     */
    @Property("api.login")
    protected String login = "at-direct-super";

    /**
     * Определяет к какой базе Баланса обращаются ручки Баланса
     */
    @Use(BillingEnvironmentConverter.class)
    @Property("api.billingEnvironment")
    protected Environment billingEnvironment = Environment.INTEGRATION;

    @Property("api.balanceSimpleEnvironment")
    protected BalanceSimpleEnvironment balanceSimpleEnvironment = BalanceSimpleEnvironment.TESTING;

    /**
     * Использование нотификаций Баланса.
     * true - дожидаемся настоящих нотифкаций
     * false - посылаем свой NotifyOrder2
     */
    @Property("api.billingNotifications")
    protected boolean billingNotifications = false;

    /**
     * Определяет стенд, на котором инициализируется песочница
     * Для режима Beta требуется также указать ее номер
     */
    @Use(StageTypeConverter.class)
    @Property("api.initSandbox")
    protected StageType initSandboxStageType = StageType.TC;

    @Use(BetaPortConverter.class)
    @Property("api.initSandbox")
    protected Integer initSandboxBetaPort;

    /**
     * Для указанных через ',' кодов при сравнении ожидаемых ошибок будет учитываться только значение errorCode
     * Может быть полезно при расхождениях переводов
     */
    @Use(ListConverter.class)
    @Property("api.ignoreDetailForCodes")
    protected List<String> ignoreDetailForCodes = new ArrayList<>();

    /**
     * Получение финансового токена напрямую из базы
     */
    @Property("api.financeTokenFromDB")
    protected boolean financeTokenFromDB = false;

    public StageType getStageType() {
        return stageType;
    }

    public String getBaseURL() {
        return baseURL;
    }

    public Integer getBetaPort() {
        return betaPort;
    }

    public int getCurrentVersion() {
        return currentVersion;
    }

    public ApiLocale getLocale() {
        return ApiLocale.valueOf(locale.toUpperCase());
    }

    public ProtocolType getDefaultProtocol() {
        return defaultProtocol;
    }

    public boolean getUseNewURLFormat() {
        return useNewUrlFormat;
    }

    public AuthType getDefaultAuthType() {
        return defaultAuthType;
    }

    public String getLogin() {
        return login;
    }

    public Environment getBillingEnvironment() {
        return billingEnvironment;
    }

    public boolean getBillingNotifications() {
        return billingNotifications;
    }

    public StageType getInitSandboxStageType() {
        return initSandboxStageType;
    }

    public Integer getInitSandboxBetaPort() {
        return initSandboxBetaPort;
    }

    public boolean getFinanceTokenFromDB() {
        return financeTokenFromDB;
    }

    public List<String> getIgnoreDetailForCodes() {
        return ignoreDetailForCodes;
    }

    public BalanceSimpleEnvironment getBalanceSimpleEnvironment() {
        return balanceSimpleEnvironment;
    }
}
