package ru.yandex.autotests.directapi;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.hazelcast.HazelcastClient;
import ru.yandex.qatools.hazelcast.HazelcastProperties;

import java.util.concurrent.TimeUnit;

public abstract class HazelcastLock {
    private static final Logger log = LoggerFactory.getLogger(HazelcastLock.class);

    private final String lockName;
    private final boolean isHazelcastEnabled;
    private final HazelcastInstance hazelcastClient;

    protected HazelcastLock(String lockName) {
        this.lockName = lockName;
        this.isHazelcastEnabled = !new HazelcastProperties().isDisabled();
        this.hazelcastClient = isHazelcastEnabled ? HazelcastClient.newHazelcastClient() : null;
    }

    public void acquire(int timeoutMinutes) {
        if (isHazelcastEnabled) {
            log.info("Trying to acquire the lock \"{}\"...", lockName);
            getLock().lock(timeoutMinutes, TimeUnit.MINUTES);
            log.info("Lock \"{}\" acquired.", lockName);
        } else {
            log.info("Hazelcast is off, no lock to acquire.");
        }
    }

    public void release() {
        if (isHazelcastEnabled) {
            getLock().forceUnlock();
            log.info("Lock \"{}\" released.", lockName);
        } else {
            log.info("Hazelcast is off, no lock to release.");
        }
    }

    private ILock getLock() {
        return hazelcastClient.getLock(lockName);
    }
}
