package ru.yandex.autotests.directapi.apiclient;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.apiclient.config.AuthType;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.httpclient.lite.core.config.HttpClientFactory;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 15.05.13
 * Time: 12:54
 * To change this template use File | Settings | File Templates.
 */
public abstract class BaseApiClient implements Cloneable {
    private static DirectTestRunProperties properties = DirectTestRunProperties.getInstance();

    public LogSteps log = LogSteps.getLogger(this.getClass());
    public static AuthType AUTH_TYPE = AuthType.TOKEN;

    protected ConnectionConfig connectionConfig;
    protected RequestHeader requestHeader;

    protected abstract ProtocolType getProtocolType();


    /**
     * Initialized with default properties
     */
    public BaseApiClient() {
        this.connectionConfig = new ConnectionConfig(properties.getDirectAPIHost());
        this.requestHeader = new RequestHeader(properties.getDirectAPILogin());
    }

    public BaseApiClient(ConnectionConfig connectionConfig) {
        this.connectionConfig = connectionConfig;
        this.requestHeader = new RequestHeader(User.get(Logins.SUPER_LOGIN));
    }

    public BaseApiClient(ConnectionConfig connectionConfig, RequestHeader requestHeader) {
        this.connectionConfig = connectionConfig;
        this.requestHeader = requestHeader;
    }

    public String login() {
        return requestHeader.getLogin();
    }

    static {
        disableSslVerification();
    }

    //TODO: move to utils

    public static ContentType getHttpResponseContentType(String url) {
        try {
            CloseableHttpClient httpClient = HttpClientFactory.getHttpClient(
                    ConnectionConfig.getHttpClientConnectionConfig(url).timeout(360)
            );

            HttpGet httpRequest = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute(httpRequest);
            try {
                return ContentType.parse(response.getEntity().getContentType().getValue());
            } finally {
                response.close();
            }
        } catch (Exception e) {
            throw new DirectAPIException("Ошибка обработки доступности URL", e);
        }

    }

    public static void disableSslVerification() {
        try {
            // Create a trust manager that does not validate certificate chains
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }
            };

            // Install the all-trusting trust manager
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new java.security.SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());

            // Create all-trusting host name verifier
            HostnameVerifier allHostsValid = new HostnameVerifier() {
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };

            // Install the all-trusting host verifier
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }
}
