package ru.yandex.autotests.directapi.apiclient;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.apiclient.methods.Action;
import ru.yandex.autotests.directapi.apiclient.methods.Method;
import ru.yandex.autotests.directapi.apiclient.version4.FinanceHeaderDataProvider;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.reports.ReportProcessingMode;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 15.05.13
 * Time: 11:55
 * request header to provide header parameters like token/locale/ etc
 */
public class RequestHeader implements Cloneable {
    @SerializedName("application_id")
    private String applicationID = "ae99016820074f809e5c268e564bebad";

    @SerializedName("login")
    private String login;

    @SerializedName("locale")
    private String locale;

    @SerializedName("token")
    private String token;

    @SerializedName("finance_token")
    private String masterToken;

    @SerializedName("operation_num")
    private Long operationNumber;

    @SerializedName("payment_token")
    private String paymentToken;

    @SerializedName("fake_login")
    private String fakeLogin;

    @SerializedName("persistent_token")
    private String persistentToken;

    @SerializedName("use_operator_units")
    private String useOperatorUnits;

    @SerializedName("token_type")
    private String tokenType;

    @SerializedName("return_money_in_micros")
    private Boolean returnMoneyInMicros;

    @SerializedName("skip_report_header")
    private Boolean skipReportHeader;

    @SerializedName("skip_column_header")
    private Boolean skipColumnHeader;

    @SerializedName("skip_report_summary")
    private Boolean skipReportSummary;

    @SerializedName("processing_mode")
    private ReportProcessingMode processingMode;

    @SerializedName("client_login")
    private String clientLogin;

    /**
     * Используется в тестах на Changes.checkCampaigns (см. DIRECT-65187)
     */
    @SerializedName("useCampAggregatedLastChange")
    private Boolean useCampAggregatedLastChange;

    /**
     * Если задано, то для методов имеющих имплементацию в Perl и Java будет
     * выбран Perl (в конфиге nginx не будет перехода на бэк java и в perl не будет работать проксирование)
     */
    @SerializedName("prefer_perl_implementation")
    private Boolean preferPerlImplementation;

    public RequestHeader clone() {
        RequestHeader clone = JsonUtils.getObject(JsonUtils.toString(this), RequestHeader.class);
        return clone;
    }

    public RequestHeader(User account) {
        initProperties(account);
    }

    public RequestHeader(String login) {
        User account = User.get(login);
        initProperties(account);
    }

    private void initProperties(User account) {
        if (account == null) {
            throw new DirectAPIException("Ошибка формирования заголовка запроса - отсутствуют данные пользователя");
        }
        this.login = account.getLogin();
        final DirectTestRunProperties properties = DirectTestRunProperties.getInstance();
        this.locale = properties.getDirectAPILocale();
        this.token = account.getToken();
        if(properties.getApi5PreferPerlImplementation()) {
            setPreferPerlImplementation(properties.getApi5PreferPerlImplementation());
        }
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setApplicationID(String applicationID) {
        this.applicationID = applicationID;
    }

    public void generateFinanceToken(String methodName) {
        generateFinanceToken(methodName, false);
    }

    public void generateFinanceToken(String methodName, boolean isSandbox) {
        FinanceHeaderDataProvider fdf = new FinanceHeaderDataProvider(
                User.get(login),
                methodName,
                isSandbox);
        this.masterToken = fdf.getMasterToken();
        this.operationNumber = fdf.getOperationNum();
    }

    public void clearFinanceToken() {
        this.masterToken = null;
        this.operationNumber = null;
    }

    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
        if (paymentToken != null) {
            this.operationNumber = System.currentTimeMillis();
        }
    }

    public void setFakeLogin(String fakeLogin) {
        this.fakeLogin = fakeLogin;
    }

    public Map<String, Object> getHeaderParameters() {
        Map<String, Object> headerKeys = new HashMap<String, Object>();
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (Field field : fields) {
                SerializedName serializedName = field.getAnnotation(SerializedName.class);
                if (serializedName != null && field.get(this) != null) {
                    headerKeys.put(serializedName.value(), field.get(this));
                }
            }
        } catch (Exception e) {
            throw new DirectAPIException("Ошибка формирования заголовка запроса", e);
        }
        return headerKeys;
    }

    public String getLogin() {
        return login;
    }

    public void setYMFinanceOAUTH() {
        clearFinanceToken();
        setPaymentToken(User.get(login).getPaymentToken());
    }

    public void setYMFinanceOAUTH(String paymentToken) {
        clearFinanceToken();
        setPaymentToken(paymentToken);
    }

    public void setDirectFinanceOAUTH(Method method) {
        setDirectFinanceOAUTH(method.toString());
    }

    public void setDirectFinanceOAUTH(Action action) {
        setDirectFinanceOAUTH(Method.ACCOUNT_MANAGEMENT.toString() + action.getAction());
    }

    public void setDirectFinanceOAUTH(Action action, boolean isSandbox) {
        setDirectFinanceOAUTH(Method.ACCOUNT_MANAGEMENT.toString() + action.getAction(), isSandbox);
    }

    public void setDirectFinanceOAUTH(String key) {
        generateFinanceToken(key);
        setPaymentToken(null);
    }

    public void setDirectFinanceOAUTH(String key, boolean isSandbox) {
        generateFinanceToken(key, isSandbox);
        setPaymentToken(null);
    }

    public void clearFinanceOAUTH() {
        clearFinanceToken();
        paymentToken = null;
    }

    public String getFakeLogin() {
        return fakeLogin;
    }

    public String getToken() {
        return token;
    }

    public String getLocale() {
        return locale;
    }

    public String getPersistentToken() {
        return persistentToken;
    }

    public void setPersistentToken(String persistentToken) {
        this.persistentToken = persistentToken;
    }

    public String getUseOperatorUnits() {
        return useOperatorUnits;
    }

    public void setUseOperatorUnits(String useOperatorUnits) {
        this.useOperatorUnits = useOperatorUnits;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Boolean getReturnMoneyInMicros() {
        return returnMoneyInMicros;
    }

    public void setReturnMoneyInMicros(Boolean returnMoneyInMicros) {
        this.returnMoneyInMicros = returnMoneyInMicros;
    }

    public Boolean getSkipReportHeader() {
        return skipReportHeader;
    }

    public void setSkipReportHeader(Boolean skipReportHeader) {
        this.skipReportHeader = skipReportHeader;
    }

    public Boolean getSkipColumnHeader() {
        return skipColumnHeader;
    }

    public void setSkipColumnHeader(Boolean skipColumnHeader) {
        this.skipColumnHeader = skipColumnHeader;
    }

    public Boolean getSkipReportSummary() {
        return skipReportSummary;
    }

    public void setSkipReportSummary(Boolean skipReportSummary) {
        this.skipReportSummary = skipReportSummary;
    }

    public ReportProcessingMode getProcessingMode() {
        return processingMode;
    }

    public void setProcessingMode(ReportProcessingMode processingMode) {
        this.processingMode = processingMode;
    }

    public String getClientLogin() {
        return clientLogin;
    }

    public void setClientLogin(String clientLogin) {
        this.clientLogin = clientLogin;
    }

    public Boolean getUseCampAggregatedLastChange() {
        return useCampAggregatedLastChange;
    }

    public void setUseCampAggregatedLastChange(Boolean useCampAggregatedLastChange) {
        this.useCampAggregatedLastChange = useCampAggregatedLastChange;
    }

    public Boolean getPreferPerlImplementation() {
        return preferPerlImplementation;
    }

    public void setPreferPerlImplementation(Boolean preferPerlImplementation) {
        this.preferPerlImplementation = preferPerlImplementation;
    }
}
