package ru.yandex.autotests.directapi.apiclient.balancexmlrpc;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

import ru.yandex.autotests.directapi.exceptions.DirectAPIException;

public class BalanceXmlRpcClient {
    protected XmlRpcClient client;

    public BalanceXmlRpcClient(String serverURL) {
        XmlRpcClientConfigImpl configXML = new XmlRpcClientConfigImpl();

        try {
            configXML.setServerURL(new URL(serverURL));
        } catch (MalformedURLException var4) {
            throw new DirectAPIException("Не удалось получить урл серванта из строки: " + serverURL);
        }

        this.client = new XmlRpcClient();
        this.client.setConfig(configXML);
    }

    private Object runRequest(String remoteProcedure, Object[] requestParams) {
        try {
            return this.client.execute(remoteProcedure, requestParams);
        } catch (XmlRpcException var4) {
            throw new DirectAPIException(var4.getMessage());
        }
    }

    public void setClientOverdraft(int clientId, int serviceId, double autoOverdraftLimit) {
        Object[] requestParams = new Object[]{clientId, serviceId, autoOverdraftLimit};
        runRequest("SetClientOverdraft", requestParams);
    }

}
