package ru.yandex.autotests.directapi.apiclient.config;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Hashtable;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

import org.apache.axis.components.net.JSSESocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.commons.lang.StringUtils;

import ru.yandex.autotests.directapi.exceptions.DirectAPIException;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 12.02.13
 * Time: 16:04
 *
 * @link http://choboboblog.blogspot.ru/2010/07/web-service-over-https.html
 */
public class MyCustomSSLSocketFactory extends JSSESocketFactory implements SecureSocketFactory {

    /* local keystore password */
    private static String MY_KEYSTORE_PASSWORD = "123456";

    /* local keystore file (contains the self-signed certificate from the server */
    public static String RESOURCE_PATH_TO_KEYSTORE = "";

    /**
     * Constructor MyCustomSSLSocketFactory
     *
     * @param attributes
     */
    public MyCustomSSLSocketFactory(Hashtable attributes) {
        super(attributes);
    }

    /**
     * Read the keystore, init the SSL socket factory
     * <p/>
     * This overrides the parent class to provide our SocketFactory implementation.
     *
     * @throws IOException
     */
    protected void initFactory() throws IOException {

        try {
            SSLContext context = getContext();
            sslFactory = context.getSocketFactory();
        } catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException) e;
            }
            throw new IOException(e.getMessage());
        }
    }

    /**
     * Gets a custom SSL Context.
     * This is the main working of this class. The following are the steps that make up our
     * custom configuration:
     * <p/>
     * 1. Open our keystore file using the password provided
     * 2. Create a KeyManagerFactory and TrustManagerFactory using this file
     * 3. Initialise a SSLContext using these factories
     *
     * @return SSLContext
     * @throws DirectAPIException
     * @throws Exception
     */
    protected SSLContext getContext() {

        char[] keystorepass = MY_KEYSTORE_PASSWORD.toCharArray();

        if (StringUtils.isBlank(new String(keystorepass))) {
            throw new DirectAPIException("Could not read password for configured keystore!");
        }

        InputStream keystoreFile = this.getClass().getClassLoader().getResourceAsStream(RESOURCE_PATH_TO_KEYSTORE);

        if (keystoreFile == null) {
            throw new DirectAPIException("Could not read the configured keystore file at " + RESOURCE_PATH_TO_KEYSTORE);
        }

        try {
// create required keystores and their corresponding manager objects
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());

            keyStore.load(keystoreFile, keystorepass);

            KeyManagerFactory kmf =
                    KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, keystorepass);

            TrustManagerFactory tmf =
                    TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);

// congifure a local SSLContext to use created keystores
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());

            return sslContext;
        } catch (Exception e) {
            throw new DirectAPIException("Error creating context for SSLSocket!", e);
        }
    }
}


