package ru.yandex.autotests.directapi.apiclient.config;

import java.util.HashMap;
import java.util.Map;

public class WsdlVersion {
/*
   ключи для описания доступных WSDL версий, для работы с сервисом
   EXTERNAL - внешние роли: агентство, клиент
   INTERNAL - внутренние роли с расширенным набором методов: супер, менеджер, суперридер итд
    */

    public enum WSDLVersion {
        EXTERNAL_ANY,
//wsdl для произвольной версии, используется в тестах, независящих от версии
        EXTERNAL_4,
        EXTERNAL_5,
        EXTERNAL_4LIVE,
        EXTERNAL_ANY45,
        //Для тестов одинаково выполняющихся в 4live и 5
        INTERNAL_ANY,
//wsdl для произвольной версии, используется в тестах, независящих от версии
        INTERNAL_4,
        INTERNAL_5,
        INTERNAL_4LIVE,
        INTERNAL_ANY45, //Для тестов одинаково выполняющихся в 4live и 5
    }

    /*
   список wsdl, используемых по умолчанию, для каждой версии
    */
    public static Map<Integer, Class> stubType =
            new HashMap<Integer, Class>() {
                {
                    put(4, ru.yandex.autotests.directapi.common.api4.APIPort_PortType.class);
                    put(1, ru.yandex.autotests.directapi.common.api4f.APIPort_PortType.class);
                    put(5, ru.yandex.autotests.directapi.common.api5.APIPort_PortType.class);
                    put(104, ru.yandex.autotests.directapi.common.api45.APIPort_PortType.class);
                    put(2, ru.yandex.autotests.directapi.common.api45f.APIPort_PortType.class);
                    put(11, ru.yandex.autotests.directapi.common.api4g.APIPort_PortType.class);
                    put(12, ru.yandex.autotests.directapi.common.api45g.APIPort_PortType.class);
                }
            };


}
