package ru.yandex.autotests.directapi.apiclient.errors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.general.ApiExceptionMessage;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.model.ApiException;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.AUTHORIZATION_ERROR;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.CANT_CREATE_LOGIN;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.CANT_PROCESS_REPORT_IN_ONLINE_MODE;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.EXCEEDED_OBJECTS_LIMIT_FOR_OPERATION;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.EXCEEDED_OBJECTS_QUEUE;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.EXCEED_LIMIT_CONNECTIONS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.EXCEED_LIMIT_OF_REQUESTS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INCOMPLETE_REGISTRATION;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INCONSISTENT_OBJECT_STATE;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INCORRECT_USE_OF_NEGATIVE_KEYWORDS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INCORRECT_USE_OF_STOPWORD;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INVALID_OFFSET;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INVALID_PARAMETERS_OF_PAGE;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INVALID_REQUEST_FORMAT;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INVALID_REQUEST_PARAMETERS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.INVALID_SELECTION_CRITERIA;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.IN_ONE_REQUEST_SHOULD_BE_ONE_TYPE_ID;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.KEYWORD_CONTAINS_TOO_MANY_WORDS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.KEYWORD_LENGTH_EXCEEDED;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.LOGIN_IS_IN_USE;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.LOGIN_IS_OCCUPIED;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.LOGIN_NOT_SWITCHED_ON_TO_DIRECT;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.MAXIMUM_NUMBER_OF_OBJECTS_REACHED;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NOT_ENOUGH_RIGHTS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NOT_ENOUGH_UNITS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NO_ACCESS_TO_API;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NO_ACCESS_TO_METHOD;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NO_ONE_OF_REQUIRED_FIELDS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NO_ONE_OF_REQUIRED_PARAMETERS;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.OBJECT_NOT_FOUND;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.OPERATION_ERROR;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.OPERATION_NOT_FOUND;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.PUT_MORE_THAN_ONE_PARAMETER;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.TOO_WIDE_SELECTION_CRITERIA;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.FIELD_SET_INCORRECTLY;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.ELEMENT_CANT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.NUMBER_OF_PERMITED_ELEMENTS_EXCEEDED_OR_EQUALS_ZERO;
import static ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage.USES_INADMISSIBLE_CHARACTERS;

/**
 * Author pavryabov
 * Date 17.07.14
 */
public class Api5Error extends RuntimeException implements Api5ErrorInfo {
    private static Logger log = LogManager.getLogger(AxisError.class);

    private String message;

    private ApiExceptionMessage faultInfo;

    // Для того чтобы исключить данное поле из сериализации в строку
    private transient boolean javaResponse;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @SuppressWarnings("WeakerAccess")
    public void setMessageFromResource(Api5ErrorMessage message) {
        TextResourceFormatter messageFormatter = TextResourceFormatter
                .resource(message)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());
        this.message = messageFormatter.toString();
    }

    public Api5Error withMessageFromResource(Api5ErrorMessage message) {
        setMessageFromResource(message);
        return this;
    }

    public Api5Error withMessageFromResource(Api5ErrorMessageJava message) {
        TextResourceFormatter messageFormatter = TextResourceFormatter
            .resource(message)
            .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());
        this.message = messageFormatter.toString();
        return this;
    }

    public ApiExceptionMessage getFaultInfo() {
        return faultInfo;
    }

    public void setFaultInfo(ApiExceptionMessage faultInfo) {
        this.faultInfo = faultInfo;
    }

    public Api5Error(ApiException apiException) {
        this(apiException, false);
    }

    public Api5Error(ApiException apiException, boolean isJavaResponse) {
        this.message = apiException.getMessage();
        this.faultInfo = new ApiExceptionMessage();
        this.faultInfo.setErrorCode(apiException.getFaultInfo().getErrorCode());
        this.faultInfo.setErrorDetail(apiException.getFaultInfo().getErrorDetail());
        this.javaResponse = isJavaResponse;
    }

    public Api5Error(int code) {
        this(code, Api5ErrorDetails.EMPTY_STRING);
    }

    public Api5Error(int code, Api5ErrorDetails details) {
        this(code, details, new Object[0]);
    }

    public Api5Error(int code, Api5ErrorDetails details, Object... detailsParams) {
        init(code, ERROR_MESSAGES, details, detailsParams);
    }

    public Api5Error(int code, Api5ErrorDetailsJava details, Object... detailsParams) {
        init(code, ERROR_MESSAGES, details, detailsParams);
    }

    private void init(int code,
            Map<Integer, Api5ErrorMessage> messagesMap,
            ITextResource details,
            Object... detailsParams)
    {
        Api5ErrorMessage message = messagesMap.get(code);
        if (message == null) {
            throw new DirectAPIException("Отсутствует маппинг кода ошибки и соответстующего сообщения. Код - " + code);
        }
        setMessageFromResource(message);
        TextResourceFormatter detailsFormatter = TextResourceFormatter
                .resource(details)
                .args(detailsParams)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());
        this.faultInfo = new ApiExceptionMessage();
        this.faultInfo.setErrorCode(code);
        this.faultInfo.setErrorDetail(detailsFormatter.toString());
    }

    public Api5JsonError toJsonError() {
        return new Api5JsonError()
                .setDetails(this.faultInfo.getErrorDetail())
                .setErrorCode(this.faultInfo.getErrorCode())
                .setMessage(message);
    }

    public Api5XmlError toXmlError() {
        Api5XmlError xmlError = new Api5XmlError()
                .setErrorDetail(this.faultInfo.getErrorDetail())
                .setErrorCode(this.faultInfo.getErrorCode())
                .setErrorMessage(message);
        return xmlError;
    }


    public boolean isJavaResponse() {
        return javaResponse;
    }

    public void setJavaResponse(boolean javaResponse) {
        this.javaResponse = javaResponse;
    }

    public String toString() {
        return JsonUtils.toString(this);
    }

    public String toExpandString() {
        StringBuilder sb = new StringBuilder(JsonUtils.toString(this));
        return sb.toString();
    }

    private java.lang.Object __equalsCalc = null;

    @Override
    public synchronized boolean equals(Object got) {
        if (!(got instanceof Api5Error)) {
            return false;
        }
        Api5Error other = (Api5Error) got;
        if (got == null) {
            return false;
        }
        if (this == got) {
            return true;
        }
        if (__equalsCalc != null) {
            return (__equalsCalc == got);
        }
        __equalsCalc = got;
        boolean _equals;
        _equals = (this.message == other.getMessage()) && this.faultInfo.equals(other.getFaultInfo());
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;

    @Override
    public Integer getErrorCode() {
        return faultInfo.getErrorCode();
    }

    @Override
    public String getErrorMessage() {
        return message;
    }

    @Override
    public String getErrorDetails() {
        return faultInfo.getErrorDetail();
    }

    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getMessage() != null) {
            _hashCode += getMessage().hashCode();
        }
        if (getFaultInfo() != null) {
            _hashCode += getFaultInfo().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    public static String enumAsParam(Class<? extends Enum> enumClass) {
        Method method = null;
        Method[] declaredMethods = enumClass.getDeclaredMethods();
        for (Method m : declaredMethods) {
            if ("value".equals(m.getName())) {
                method = m;
                break;
            }
            if ("name".equals(m.getName())) {
                method = m;
            }
        }
        final Method m = method;
        return Stream.of(enumClass.getEnumConstants())
                .map(e -> {
                    try {
                        return (String) (m != null ? m.invoke(e) : null);
                    } catch (IllegalAccessException | InvocationTargetException e1) {
                        // ignore
                    }
                    return null;
                })
                .collect(Collectors.joining(", "));
    }

    private static final Map<Integer, Api5ErrorMessage> ERROR_MESSAGES = ImmutableMap.<Integer, Api5ErrorMessage>builder()
            .put(53, AUTHORIZATION_ERROR)
            .put(54, NOT_ENOUGH_RIGHTS)
            .put(55, OPERATION_NOT_FOUND)
            .put(56, EXCEED_LIMIT_OF_REQUESTS)
            .put(58, INCOMPLETE_REGISTRATION)
            .put(152, NOT_ENOUGH_UNITS)
            .put(252, LOGIN_IS_OCCUPIED)
            .put(253, CANT_CREATE_LOGIN)
            .put(506, EXCEED_LIMIT_CONNECTIONS)
            .put(513, LOGIN_NOT_SWITCHED_ON_TO_DIRECT)
            .put(1005, OPERATION_ERROR)
            .put(1016, INVALID_OFFSET)
            .put(3000, NO_ACCESS_TO_API)
            .put(3001, NO_ACCESS_TO_METHOD)
            .put(4000, INVALID_REQUEST_PARAMETERS)
            .put(4001, INVALID_SELECTION_CRITERIA)
            .put(4002, INVALID_PARAMETERS_OF_PAGE)
            .put(4003, NO_ONE_OF_REQUIRED_PARAMETERS)
            .put(4004, PUT_MORE_THAN_ONE_PARAMETER)
            .put(4005, IN_ONE_REQUEST_SHOULD_BE_ONE_TYPE_ID)
            .put(5002, USES_INADMISSIBLE_CHARACTERS)
            .put(5008, NO_ONE_OF_REQUIRED_FIELDS)
            .put(5140, KEYWORD_CONTAINS_TOO_MANY_WORDS)
            .put(5141, INCORRECT_USE_OF_STOPWORD)
            .put(5142, KEYWORD_LENGTH_EXCEEDED)
            .put(5161, INCORRECT_USE_OF_NEGATIVE_KEYWORDS)
            .put(5200, LOGIN_IS_IN_USE)
            .put(5005, FIELD_SET_INCORRECTLY)
            .put(6000, INCONSISTENT_OBJECT_STATE)
            .put(7000, NUMBER_OF_PERMITED_ELEMENTS_EXCEEDED_OR_EQUALS_ZERO)
            .put(7001, MAXIMUM_NUMBER_OF_OBJECTS_REACHED)
            .put(8000, INVALID_REQUEST_FORMAT)
            .put(8800, OBJECT_NOT_FOUND)
            .put(8312, CANT_PROCESS_REPORT_IN_ONLINE_MODE)
            .put(9000, EXCEEDED_OBJECTS_QUEUE)
            .put(9300, EXCEEDED_OBJECTS_LIMIT_FOR_OPERATION)
            .put(9301, TOO_WIDE_SELECTION_CRITERIA)
            .put(9800, OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST)
            .put(9802, ELEMENT_CANT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME)

            .build();
}
