package ru.yandex.autotests.directapi.apiclient.errors;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Author pavryabov
 * Date 18.07.14
 * Список ключей к описаниям ошибок API5.
 * Тексты ошибок содержатся в ресурсах локализации
 * <p>
 * Для добавления воспользоваться ссылкой: https://direct-handles.qart.yandex-team.ru/testdata/textResourceActions.html
 * ключ - префикс + код ошибки (пример: api.Api5ErrorDetails.ACCESS_BLOCKED)
 *
 * @see /APIAxisErrorDetails
 */
public enum Api5ErrorDetails implements ITextResource {
    ACCESS_BLOCKED,
    ACCESS_DENIED_FOR_LIGHTS_USERS,
    AD,
    ADGROUP_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
    ADGROUP_SUBTYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
    ADDITIONAL_METRICA_COUNTERS_INCORRECTLY_SPECIFIED,
    AD_CAN_CONTAIN_ONLY_ONE_TYPE,
    AD_CANT_BE_DELETED,
    AD_EXTENSION_ALREADY_LINKED,
    AD_EXTENSION_EXISTS_ALREADY,
    AD_EXTENSION_ID_PRESENT_MORE_THAN_ONCE_IN_REQUEST,
    AD_EXTENSION_IS_MARKED_AS_DELETED,
    AD_EXTENSION_NOT_LINKED,
    AD_EXTENSION_NOT_FOUND,
    AD_EXTENSION_NOT_FOUND_NO_ID,
    AD_EXTENSIONS_TEXT_ONLY_FOR_UKRAINE,
    AD_EXTENSIONS_TEXT_ONLY_FOR_TURKEY,
    AD_EXTENSIONS_TEXT_ONLY_FOR_KAZAKHSTAN,
    AD_IS_ARCHIVED_AND_CANT_BE_MODERATED,
    AD_IS_ARCHIVED_AND_CANT_BE_RESUME,
    AD_IS_ARCHIVED_AND_CANT_BE_SUSPENDED,
    AD_IS_DRAFT_AND_CANT_BE_RESUMED,
    AD_IS_DRAFT_AND_CANT_BE_ARCHIVED,
    AD_IS_DRAFT_AND_CANT_BE_SUSPENDED,
    AD_MORE_THAN_ONCE_IN_REQUEST,
    AD_MUST_CONTAIN_ONLY_ONE_OF_THE_OBJECTS,
    AD_MUST_CONTAIN_ONE_OF_THE_OBJECTS,
    AD_NOT_FOUND,
    AD_NOT_SUPPORTED,
    AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF,
    AD_TARGET_NOT_FOUND,
    AD_TEXT_ONLY_FOR_KAZAKHSTAN,
    AD_TEXT_ONLY_FOR_TURKEY,
    AD_TEXT_ONLY_FOR_UKRAINE,
    AD_TEXT_ONLY_FOR_BELARUS,
    AD_TEXT_ONLY_FOR_UZBEKISTAN,
    AD_TYPE_NOT_MATCH_TYPE_IN_REQUEST,
    ADD_NO_MORE_THAN,
    ADD_NO_MORE_THAN_ADS,
    ADD_NO_MORE_THAN_CAMPAIGNS,
    ADS_WONT_BE_SHOWN_DUE_TO_LEGAL_RESTRICTIONS,
    ADGROUP_COULD_CONTAIN_KEYWORD_COUNT,
    ADGROUP_NOT_FOUND,
    ADGROUP_NOT_FOUND_BY_ID,
    ADGROUP_NOT_SUPPORTED,
    ADGROUP_TYPE_DOESNT_MATCH_CAMPAIGN_TYPE,
    ADGROUP_TYPE_NOT_SUPPORTED,
    ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED,
    AGE_LABEL_CAN_TAKE_ONE_OF_THE_FOLLOWING_VALUES,
    ALL_REGIONS_CANNOT_BE_EXCLUDED,
    ALLOW_DELETE_NO_MORE_WEBPAGES,
    ALLOW_ONLY_ONE_FILTER,
    ALLOW_SUSPEND_NO_MORE_WEBPAGES,
    ALLOW_RESUME_NO_MORE_WEBPAGES,
    ALLOWED_TO_FILTER_ONLY_OPERATORS_EQUALS_AND_IN,
    ALLOWED_TO_FILTER_ONLY_AGES,
    ALLOWED_TO_FILTER_EQUALS_ONLY_ONE_VALUE,
    ALLOWED_TO_FILTER_IN_ONLY_10000_VALUE,
    ALLOWED_TO_FILTER_THIS_FIELD_ONLY_OPERATORS,
    ALLOWED_TO_INSTALL_ONLY_MONTH_N,
    ALLOWED_TO_INSTALL_ONLY_AGE_N,
    AMOUNT_OF_ELEMENTS_IN_FIELD_MUST_NOT_EXCEED,
    API_USAGE_NOT_ALLOWED_DURING_CONVERTATION,
    ARRAY_CANNOT_CONTAIN_MORE_THAN,
    AT_LEAST_ONE_COMPLETED_GOAL,
    AT_LEAST_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
    AT_LEAST_ONE_OF_FOLLOWING_FIELDS_SHOULD_BE_SET,
    AUDIENCE_TARGETS_NOT_FOUND,
    AUDIENCE_TARGETS_DENIED_GROUP_TYPE,
    AUDIENCE_TARGETS_FORBIDDEN_TO_ADD_IN_ARCHIVE_CAMPAIGN,
    AUDIENCE_TARGETS_FORBIDDEN_TO_DELETE_IN_ARCHIVE_CAMPAIGN,
    AUDIENCE_TARGETS_FORBIDDEN_TO_RESUME_IN_ARCHIVE_CAMPAIGN,
    AVERAGE_PRICE_NOT_SPECIFIED,
    AVERAGE_CPA_NOT_SPECIFIED,
    AVERAGE_CPA_SHOULD_BE_MORE_THAN,
    AVERAGE_CPA_SHOULD_BE_NO_MORE_THAN,
    AVERAGE_CPC_VALUE_NOT_SPECIFIED,
    AVERAGE_CPI_NOT_SPECIFIED,
    AVERAGE_CPI_SHOULD_BE_NO_MORE_THAN,
    AVERAGE_CPI_SHOULD_BE_MORE_THAN,
    AVERAGE_CPM_SHOULD_BE_LESS_THAN,
    AVERAGE_CPM_SHOULD_BE_MORE_THAN,
    AVERAGE_CPV_SHOULD_BE_MORE_THAN,
    AVERAGE_CPV_STRATEGY_IS_ONLY_APPLICABLE_TO_CAMPAIGNS_WITH_VIDEO_GROUPS,
    AVERAGE_PRICE_SHOULD_BE_LESS_THAN,
    AVERAGE_PRICE_SHOULD_BE_MORE_THAN,
    AUDIENCE_TARGETS_DELETE_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_ADD_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_RESUME_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_SET_BIDS_AD_GROUP_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_SET_BIDS_CAMPAIGN_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_SET_BIDS_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_SUSPEND_LIMIT_EXCEEDED,
    AUDIENCE_TARGET_ALREADY_STOPPED,
    AUDIENCE_TARGET_IS_NOT_STOPPED,
    AUTOTARGETING_CATEGORIES_FOR_THIS_AD_GROUP_ARE_NOT_ALLOWED,
    BAD_FIELD_PARAMS,
    BID_MODIFIER_NOT_FOUND,
    BID_MODIFIER_COULD_NOT_BE_PRESENTED_MORE_THAN_ONCE,
    BID_MODIFIER_SET_NOT_FOUND,
    BID_MODIFIER_SHOULD_BE_NOT_LESS,
    BID_MODIFIER_SHOULD_BE_NOT_MORE,
    BID_MODIFIER_SHOULD_NOT_BE_PRESENTED_TWICE,
    BID_MODIFIER_ADJUSTMENT_INTERSECTION,
    BID_MODIFIERS_ADD_IN_REQUEST_LIMIT,
    BID_MODIFIERS_AGE_OR_GENDER_REQUIRED,
    BID_MODIFIERS_DELETE_LIMIT_EXCEEDED,
    BID_MODIFIERS_DEMOGRAPHICS_IN_REQUEST_LIMIT,
    BID_MODIFIER_SERP_LAYOUT_ADJUSTMENT_INTERSECTION,
    BID_MODIFIERS_SERP_LAYOUT_IN_REQUEST_LIMIT,
    BID_MODIFIERS_RETARGETING_IN_REQUEST_LIMIT,
    BID_MODIFIER_REGIONAL_ADJUSTMENT_INTERSECTION,
    BID_MODIFIERS_SET_IN_REQUEST_LIMIT,
    BID_MODIFIERS_TOGGLE_IN_REQUEST_LIMIT,
    BIDS_MISSING_ELEMENT_OR_BLOCK_AT_GET,
    BIDS_MISSING_ELEMENT_OR_BLOCK_AT_GET_SELECTION_CRITERIA,
    BIDS_MISSING_ELEMENT_OR_BLOCK_AT_SET,
    BIDS_MISSING_ELEMENT_OR_BLOCK_AT_SET_AUTO,
    BIDS_MISSING_ELEMENT_OR_BLOCK_AT_SET_AUTO_BIDS,
    BIDS_REQUIRED_VALUE_FOR_ELEMENT_MISSING_AT_GET,
    BIDS_SET_NO_MORE_THAN,
    BIDS_SET_AUTO_NO_MORE_THAN,
    BIDS_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_SEARCH,
    BID_PERCENT_SHOULD_BE_IN_INTERVAL,
    BID_PERCENT_SHOULD_BE_MULTIPLE_OF_TEN,
    BID_ON_NETWORK_WILL_NOT_APPLIED_BECAUSE_NETWORK_DEPENDS_ON_SEARCH,
    BID_ON_NETWORK_WILL_NOT_APPLIED_WHEN_NETWORK_OFF,
    BID_SHOULD_NOT_BE_LESS_THAN,
    BID_SHOULD_NOT_BE_MORE_THAN,
    BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
    BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_AUTO_STRATEGY,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_SEARCH,
    BID_WILL_NOT_APPLIED_BECAUSE_SET_STRATEGY_IN_WHICH_NETWORK_DEPENDS_ON_SEARCH,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_CONTEXT,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_CONTEXT_FOR_AUTOTARGETING,
    BLOCK_MISSING_AT_ADGROUPS,
    BLOCK_MISSING_AT_ADGROUPSADDREQUEST,
    BLOCK_MISSING_ADGROUPSDELETEREQUEST,
    BLOCK_MISSING_AT_ADGROUPSUPDATEREQUEST,
    BLOCK_MISSING_AT_ADGROUPSGETREQUEST,
    BLOCK_MISSING_AT_DELETE_SELECTIONCRITERIA,
    BLOCK_MISSING_AT_NEGATIVEKEYWORDS,
    BLOCK_MISSING_AT_UPDATE_NEGATIVEKEYWORDS,
    BUDGET_EXPENDITURE_FOR_ADDITIONAL_RELEVANT_PHRASES_SPECIFIED_INCORRECTLY,
    BUDGET_MUST_BE_ABOVE,
    CALLOUT_EXISTS_ALREADY,
    CALLOUT_TEXT_CONTAINS_INVALID_CHARACTERS,
    CALLOUT_TEXT_IS_EMPTY,
    CALLOUT_TEXT_SHOULD_BE_UNIQUE,
    CALLOUT_TEXT_TEXT_SIZE_EXCEEDED,
    CAMPAIGNS_NAME_CONTAINS_SPECIAL_CHARACTERS,
    CAMPAIGN_ARCHIVED,
    CAMPAIGN_ALREADY_ARCHIVED,
    CAMPAIGN_ALREADY_SUSPENDED,
    CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
    CAMPAIGN_WITH_MONEY_COULD_NOT_BE_DELETED,
    CAMPAIGN_DELETED,
    CAMPAIGN_ID_IS_PRESENTED_MORE_THAN_ONCE_IN_REQUEST,
    CAMPAIGN_IN_DETAILS,
    CAMPAIGN_IS_IN_SPECIAL_ARCHIVED_STATE,
    CAMPAIGNINFO_FEW_ADD_HOURS,
    CAMPAIGN_HAS_INSTALLED_AUTO_STRATEGY,
    CAMPAIGN_MUST_BE_STOPPED_BEFORE_ARCHIVATION,
    CAMPAIGN_MUST_CONTAIN_ONE_OF_THE_OBJECTS,
    CAMPAIGN_NAME_IS_EMPTY,
    CAMPAIGN_NAME_LENGTH_EXCEEDED,
    CAMPAIGN_NOT_ARCHIVED,
    CAMPAIGN_NOT_FOUND,
    CAMPAIGN_NOT_FOUND_BY_ID,
    CAMPAIGN_NOT_OWNED_BY_USER,
    CAMPAIGN_NOT_SUSPENDED,
    CAMPAIGN_SETTING_DEPRECATED,
    CAMPAIGN_SHOULD_BE_UNARCHIVED,
    CAMPAIGN_TYPE_NOT_MATCHES_WITH_TYPE_IN_REQUEST,
    CAMPAIGN_TYPE_NOT_SUPPORTED,
    CAMPAIGN_WILL_NOT_BE_SENT_TO_SERVING,
    CANNOT_HAVE_NULL_VALUE,
    CANNOT_SPECIFY_DIFFERENT_OPERATIONS_IN_ONE_REQUEST,
    CANT_ARCHIVE_ACTIVE_AD,
    CANT_ARCHIVE_AD_IN_ARCHIVED_CAMPAIGN,
    CANT_DELETE_AD_IN_ARCHIVED_CAMPAIGN,
    CANT_PROCESS_REPORT_IN_ONLINE_MODE,
    CANT_UNARCHIVE_AD_IN_ARCHIVED_CAMPAIGN,
    CANT_UPDATE_AD_IN_ARCHIVED_CAMPAIGN,
    CANT_UPDATE_ARCHIVED_AD,
    CHANGE_BIDS_ON_NETWORK_NOT_ALLOWED_BECAUSE_NETWORK_DEPANDS_ON_SEARCH,
    CHANGE_BIDS_ON_NETWORK_NOT_ALLOWED_WHEN_NETWORK_OFF,
    CHANGE_BIDS_ON_SEARCH_NOT_ALLOWED_BECAUSE_SHOWS_DISABLED,
    CHANGE_DAY_BUDGET_NOT_MORE_THAN_3_TIMES,
    COMPLEX_TYPE_REQUIRES_INPUT_DATA_HASH,
    COULD_NOT_RETRIEVE_APPLICATION_INFORMATION,
    COUNTRY_CODE_MUST_START_WITH_PLUS,
    CLICKS_PER_WEEK_SHOULD_BE_NOT_LESS_THAN,
    CLIENT_BLOCKED,
    CLIENT_CANT_BE_SERVICED_BY_SEVERAL_AGENCIES,
    CLIENT_INFO_IS_EMPTY,
    CLIENT_INFO_LENGTH_EXCEEDED,
    CLIENT_INFO_NOT_FILLED,
    CLIENT_LOGIN_MUST_BE_CLIENT_OR_SUBCLIENT,
    CLIENT_LOGIN_MUST_BE_AGENCY,
    CLIENT_MUST_ACCEPT_CONVERTATION_OFFER,
    CLIENT_NAME_CONTAINS_SPECIAL_CHARACTERS,
    CLIENT_NOT_FOUND,
    CONTACT_INFO_COUNTRY_CODE_MUST_START_FROM,
    CONTACT_INFO_COUNTRY_CODE_WITH_CITY_CODE_SHOULD_NOT_START_WITH_PLUS,
    COULD_NOT_DELETE,
    COULD_NOT_ADD_VCARD_TO_ARCHIVED_CAMPAIGN,
    COULD_NOT_ARCHIVE_CAMPAIGN_WITH_MONEY,
    COMPLEX_REQUIRES_A_HASH_NOT_ARRAY_SITELINKS_DELETE,
    COMPLEX_REQUIRES_A_HASH_NOT_ARRAY_SITELINKS_GET,
    COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER,
    CORRECT_DATE_MUST_BE_SPECIFIED,
    CPM_BANNER_ADGROUP_ON_DELETE,
    CPM_BANNER_IN_YND_FIXED_NOT_SUPPORTED,
    CREATE_CAMPAIGN_IMPOSSIBLE_LOGIN_UNSERVICED,
    CREATIVE_NOT_FOUND,
    CP_START_DATE_CANT_BE_EARLY_THAN_CAMPAIGN_START_DATE,
    CP_DATE_CANT_BE_EARLY_THAN_TODAY,
    DATE_CANT_BE_EARLIER_THAN_NOW,
    CP_END_DATE_CANT_BE_LATER_END_DATE,
    CP_START_DATE_CANT_BE_LATER_END_DATE,
    DAILY_BUDGET_CAN_ONLY_USED_WITH_MANUAL_STRATEGIES,
    DAILY_BUDGET_MAKES_SENSE_ONLY_FOR_MANUAL_STRATEGIES,
    DAILY_BUDGET_MINIMUM_WITH_CURRENCY,
    DAILY_BUDGET_MAXIMUM_WITH_CURRENCY,
    DAILY_BUDGET_NOT_ENOUGH_RIGHTS,
    DATE_IN_FUTURE,
    DATE_INVALID_FORMAT_IN_FILED,
    DATE_TO_CANT_BE_EARLY_DATE_FROM,
    DIFFERENT_AD_IMAGE_SIZE_FOR_THIS_BANNER_IN_UPDATE,
    DIFFERENT_REPORT_WITH_SAME_NAME,
    DISPLAY_URL_PATH_WITHOUT_HREF,
    DISPLAY_URL_PATH_ONLY_FOR_UKRAINE,
    DISPLAY_URL_PATH_ONLY_FOR_TURKEY,
    DISPLAY_URL_PATH_ONLY_FOR_KAZAKHSTAN,
    DENIED_ADD_AD_TO_ARCHIVED_CAMPAIGN,
    DENIED_MODERATE_ADS_IN_ARCHIVED_CAMPAIGN,
    DENIED_RESUME_ADS_IN_ARCHIVED_CAMPAIGN,
    DENIED_STOP_ADS_IN_ARCHIVED_CAMPAIGN,
    DEVICE_BID_MODIFIERS_ALL_ZEROS,
    DUPLICATE_KEYWORD_IDS,
    DYNAMIC_GROUP_NOT_FOUND,
    ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
    ELEMENT_OF_ARRAY_CANT_BE_NULL,
    ELEMENT_OF_ARRAY_CANT_HAVE_NULL_VALUE,
    ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
    ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
    ELEMENT_OF_ARRAY_MUST_BE_POSITIVE_INTEGER,
    ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
    ELEMENT_OF_ARRAY_MUST_CONTAIN_OBJECT,
    ELEMENT_OF_ARRAY_MUST_CONTAIN_STRING,
    ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
    EMAIL_LENGTH_EXCEEDED,
    EMAIL_IS_EMPTY,
    EMPTY_STRING,
    EMPTY_AREA_CODE,
    EMPTY_COUNTRY_CODE,
    EMPTY_HREF,
    EMPTY_PHONE_NUMBER,
    EMPTY_START_DATE,
    ENABLE_ARCHIVE_NO_MORE_ADS_FOR_OPERATION,
    ENABLE_GEO_ONLY_FOR_UKRAINE,
    ENABLE_GEO_ONLY_FOR_TURKEY,
    ENABLE_GEO_ONLY_FOR_KAZAKHSTAN,
    ENABLE_DELETE_NO_MORE_ADS_FOR_OPERATION,
    ENABLE_MODERATE_NO_MORE_ADS_FOR_OPERATION,
    ENABLE_RELATED_KEYWORDS_DEPRECATED,
    ENABLE_RESUME_NO_MORE_ADS_FOR_OPERATION,
    ENABLE_SUSPEND_NO_MORE_ADS_FOR_OPERATION,
    ENABLE_UNARCHIVE_NO_MORE_ADS_FOR_OPERATION,
    END_DATE_CANNOT_BE_BEFORE_START_DATE,
    END_DATE_MUST_FOLLOW_TODAY_DATE,
    ENTER_ROI_COEF_VALUE,
    ERROR_IN_FIELD,
    EXCEED_LIMIT_CONNECTIONS,
    EXCEEDED_MAX_LENGTH_IN_ARGUMENTS,
    EXCLUDED_SITES_CONTAINS_INTERNAL_PAGE,
    EXPECTED_SINGLE_VALUE_NOT_ARRAY,
    LIMIT_OF_METHOD_REQUESTS,
    FIELD_CONTAIN_UNKNOWN_FIELD,
    FIELD_CANNOT_HAVE_VALUE,
    FIELD_CANT_CONTAINS_WORDS_OF_LENGTH,
    FIELD_MUST_BE_LESS_THEN_FIELD,
    FIELD_MUST_BE_IN_RANGE_FROM_TO,
    FIELD_MUST_BE_POSITIVE_INTEGER,
    FIELD_MUST_BE_POSITIVE_INTEGER_BM,
    FIELD_MUST_BE_POSITIVE_NUMBER,
    FIELD_MUST_CONTAIN_ARRAY,
    FIELD_MUST_CONTAIN_INTEGER_VALUE,
    FIELD_MUST_CONTAIN_OBJECT,
    FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
    FIELD_MUST_CONTAIN_STRING,
    FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
    FIELD_MUST_EQUAL_TO_ONE_OF_THESE_VALUES,
    FIELD_MUST_NOT_CONTAIN_ARRAY,
    FIELD_MUST_CONTAIN_VALUE_FROM_TO,
    FIELD_NEED_DEFINED_OTHER_FIELD,
    FIELD_SHOULD_NOT_BE_EMPTY,
    FIELD_SHOULD_NOT_BE_MORE_THAN,
    FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
    FIELD_WILL_NOT_CHANGE_BECAUSE_OF_MANUAL_STRATEGY,
    FIXED_PERIOD_BUDGET_CANNOT_BE_LESS,
    FIXED_PERIOD_BUDGET_CANNOT_BE_MORE,
    FORBIDDEN_SUSPEND_AUDIENCE_TARGET_IN_CAMPAIGN,
    FORBIDDEN_TO_CREATE_KEYWORDS_IN_GROUP_OF_THIS_TYPE,
    FOR_AUTO_STRATEGY_FIELD_MUST_BE_SPECIFIED,
    FOR_INDEPENDENT_CONTROL_STRATEGY_ONE_OF_FIELDS_SHOULD_BE,
    FOR_MANUAL_STRATEGY_ON_SEARCH_FIELD_MUST_BE_SPECIFIED,
    FOR_MANUAL_STRATEGY_ON_NETWORK_FIELD_MUST_BE_SPECIFIED,
    FOR_UPDATING_BIDS_ON_NETWORK_SHOULD_SPECIFIED,
    FOR_UPDATING_BIDS_ON_SEARCH_SHOULD_SPECIFIED,
    FOR_UPDATING_BIDS_ON_SEARCH_SHOULD_SPECIFIED_IF,
    GETTING_FIELD_UNAVAILABLE_WITH_SOME_AGENCY,
    GOAL_ID_IN_FIELD_NOT_FOUND,
    GOAL_NOT_FOUND,
    GOAL_NOT_SET,
    GOAL_TIME_SPECIFIED_INCORRECTLY,
    GOALS_AMOUNT_SHOULD_BE_MORE_THAN_0,
    HEADER_USE_OPERATOR_UNITS_INACCESSIBLE,
    HOLIDAY_SHEDULE_CANT_CONTAINS_FIELD,
    HOLIDAY_BID_PERCENT_MUST_BE_100_FOR_CPM_BANNER,
    HOLIDAY_BID_PERCENT_MUST_BE_FROM_TO,
    HOLIDAY_BID_PERCENT_MUST_DIV_BY_10,
    INCORRECT_GOAL_SET,
    GROUP_NAME_CANNOT_BE_EMPTY_STRING,
    GROUP_NAME_CANNOT_CONTAIN_255_SYMBOLS,
    GROUP_NOT_FOUND,
    ILLEGAL_VALUE_FOR_ADDREQUEST_CAMPAIGNID,
    ILLEGAL_VALUE_FOR_ADDREQUEST_REGIONIDS,
    ILLEGAL_VALUE_FOR_TYPE_SITELINKS_DELETE,
    ILLEGAL_VALUE_FOR_TYPE_SITELINKS_GET,
    ILLEGAL_VALUE_FOR_UPDATEREQUEST_ID,
    ILLEGAL_VALUE_FOR_UPDATEREQUEST_REGIONIDS,
    ILLEGAL_VALUE_FOR_TYPE_LONG,
    ILLEGAL_VALUE_FOR_TYPE_STRING,
    IMAGE_ADD_LIMIT_EXCEEDED,
    IMAGE_FILE_SIZE_INVALID,
    IMAGE_FILE_SIZE_INVALID_IMAGEAD,
    IMAGE_FORMAT_INVALID,
    IMAGE_HASH_IS_PRESENTED_MORE_THAN_ONCE_IN_REQUEST,
    IMAGE_HASH_CANNOT_BE_EMPTY,
    IMAGE_HASH_SHOULD_BE_CORRECT,
    IMAGE_NOT_FOUND,
    IMAGE_SIZE_INVALID,
    IMPRESSIONS_ON_SITE_CANNOT_BE_DISABLED,
    IMPROPER_USE_OF_PUNCTUATION_MARKS_IN_THE_FIELD,
    INCONSISTENT_STATE_WITH_BID_CEILING_AND_AVERAGE_CPC,
    INCONSISTENT_STATE_WITH_BID_CEILING_AND_PAY_FOR_CONVERSION,
    PAY_FOR_CONVERSION_LIMIT_ACCESS,
    INELIGIBLE_DYNAMIC_ADGROUP_SUBTYPE_FOR_WEBPAGES,
    IN_CONDITION_ALLOWED_TO_USE_LETTERS,
    IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
    INCORRECT_RULE_FORMAT_EMPTY_ARGUMENT,
    INVALID_CAMPAIGN_END_DATE,
    INVALID_CAMPAIGN_START_DATE,
    INVALID_DOMAIN_FORMAT,
    INVALID_ENUMERATE_AT_SITELINKS,
    INVALID_GROUP_TYPE,
    INVALID_START_OF_PERIOD,
    INVALID_END_OF_PERIOD,
    INVALID_TIME_FROM,
    INVALID_TIME_TO,
    INVALID_VALUE_SOURCE,
    INVALID_VALUE_SOURCE_UPDATE,
    IN_ONE_REQUEST_SHOULD_BE_ONE_TYPE_ID,
    IN_PARAMS_THE_REQUIRED_FIELD_IS_MISSING,
    IN_SELECTION_CRITERIA_THE_REQUIRED_FIELD_IS_MISSING,
    IN_STRUCTURE_MUST_BE_ONE_OF_REQUIRED_FIELD,
    INCOMPATIBLE_FIELDS,
    INCOMPATIBLE_FIELDS_IN_FIELDNAMES,
    INCOMPATIBLE_FIELDS_IN_FIELDNAMES_AND_FILTER,
    INCOMPATIBLE_FIELDS_IN_FILTER,
    INCORRECT_ATTRIBUTION_MODEL_SPECIFIED,
    INCORRECT_FIELD,
    INCORRECT_DATE_FORMAT,
    INCORRECT_EMAIL_FORMAT,
    INCORRECT_ENUMERATE_VALUE,
    INCORRECT_IDENTIFICATOR_FOR_FILTER,
    INCORRECT_LINK,
    INCORRECT_USE_OF_BRACKETS_IN_MINUS_PHRASE,
    INCORRECT_USE_OF_SYMBOL_IN_KEYWORD,
    INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE,
    INCORRECT_USE_OF_SYMBOL_IN_START_OR_END_OF_MINUS_PHRASE,
    INCORRECT_VALUE_FOR_FILTER,
    INSUFFICIENT_AMOUNT_ON_ACCOUNT,
    INVALID_AD_IMAGE_SIZE_FOR_THIS_CAMPAIGN_TYPE,
    INVALID_AD_IMAGE_TYPE_FOR_THIS_BANNER,
    INVALID_AREA_CODE_FORMAT,
    INVALID_CONTACT_EMAIL_FORMAT,
    INVALID_COUNTRY_CODE_FORMAT,
    INVALID_SYMBOL_IN_DISPLAY_URL_PATH,
    INVALID_ENUMERATE_AT,
    INVALID_ENUMERATE_AT_ADGROUPS_FIELDNAMES,
    INVALID_ENUMERATE_AT_ADGROUPS_STATUSES,
    INVALID_ENUMERATE_AT_FIELD_NAMES,
    INVALID_ENUMERATE_AT_SITELINKS_FIELDNAMES,
    INVALID_FORMAT_CONDITION_URL,
    INVALID_FORMAT_WEBPAGE_CONDITION,
    INVALID_FIELD_FOR_CAMP_TYPE,
    INVALID_IM_LOGIN_ICQ,
    INVALID_IM_LOGIN_SKYPE,
    INVALID_IM_LOGIN_MAIL_AGENT,
    INVALID_KEYWORD_SYMBOLS,
    INVALID_METRO_STATION,
    INVALID_PARAMETER,
    INVALID_PRIMARY_DOMAIN_OF_AD_GROUP,
    INVALID_TIME_ZONE,
    INVALID_TRACKING_URL,
    INVALID_QUICK_LINK_FORMAT,
    INVALID_TOKEN_FORMAT,
    INVALID_OGRN,
    INVALID_OR_NONEXISTENT_REGION,
    INVALID_PHONE_NUMBER_FORMAT,
    INVALID_PHONE_EXTENSION_FORMAT,
    INVALID_VALUE_IN_FIELD,
    INCORRECT_VALUE_FOR_FILTER_AGE_45,
    KEYWORD_COULD_NOT_BE_USED_AS_MINUS_WORD,
    KEYWORD_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY,
    KEYWORD_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY,
    KEYWORD_COULD_NOT_CONTAIN_MORE_WORDS,
    KEYWORD_COULD_NOT_END_WITH_APOSTROPHE,
    KEYWORD_COULD_NOT_START_WITH_DOT_OR_APOSTROPHE,
    KEYWORD_ID_COULD_NOT_REPEAT_IN_REQUEST,
    KEYWORD_ID_DUPLICATED,
    KEYWORD_INCORRECT_COMBINATION_OF_CHARACTERS,
    KEYWORD_INCORRECT_USAGE_OF_QUOTES,
    KEYWORD_IN_REQUEST_LIMIT,
    KEYWORD_MAX_LENGTH_EXCEEDED,
    KEYWORD_MAX_LENGTH_EXCEEDED_INDIVIDUAL,
    KEYWORD_MINUS_WORD_LENGTH_EXCEEDED,
    KEYWORDS_DELETE_MISSING_ELEMENT_OR_BLOCK,
    KEYWORDS_DELETE_LIMIT_EXCEEDED,
    KEYWORDS_LIMIT_MUST_BE_MORE_THAN_0,
    KEYWORDS_LIMIT_CANNOT_BE_MORE,
    KEYWORDS_PAGE_LIMIT_SHOULD_BE_IN_INTERVAL,
    KEYWORDS_RESUME_LIMIT_EXCEEDED,
    KEYWORDS_RESUME_MISSING_ELEMENT_OR_BLOCK,
    KEYWORDS_SUSPEND_LIMIT_EXCEEDED,
    KEYWORDS_SUSPEND_MISSING_ELEMENT_OR_BLOCK,
    KEYWORDS_NOT_FOUND_FOR_ID,
    KEYWORD_NOT_FOUND,
    KEYWORD_UPDATE_REQUEST_LIMIT,
    KRIM_CANNOT_BE_EXLUDED_FROM_ANYWHERE,
    LENGTH_OF_SITELINK_DESCRIPTION_EXCEEDED,
    LENGTH_OF_SITELINK_HREF_EXCEEDED,
    LIMIT_CANNOT_BE_MORE,
    LIMIT_AND_OFFSET_CANNOT_BE_MORE,
    LIMIT_MUST_BE_MORE_THAN_0,
    LIMIT_OF_AD_EXTENSIONS_FOR_AD_EXCEEDED,
    LIMIT_PERCENT_SHOULD_BE_IN_INTERVAL,
    LIMIT_PERCENT_SHOULD_BE_MULTIPLE_OF_TEN,
    LINK_HAS_EXCEEDED_CHARACTER_LIMIT,
    LOGIN_NOT_MATCH_TOKEN,
    LOGIN_NOT_SWITCHED_ON_TO_DIRECT,
    LOGIN_REQUIRED,
    MAP_POINT_SET_INCORRECTLY,
    MAX_BID_SHOULD_BE_LESS_THAN,
    MAX_BID_SHOULD_BE_MORE_THAN,
    MAX_CALLOUTS_REACHED,
    MAX_NUMBER_OF_NARROW_CHARACTERS_IN_FIELD_EXCEEDED,
    MAXIMUM_GROUPS_IN_CAMPAIGN_REACHED,
    MAXIMUM_NUMBER_OF_ADS_IN_GROUP_REACHED,
    MAXIMUM_NUMBER_OF_BLOCKED_IPS_EXCEEDED,
    MAXIMUM_NUMBER_OF_CAMPAIGNS_EXCEEDED,
    MAXIMUM_QUICK_LINK_LENGTH_HAS_BEEN_EXCEEDED,
    MAXIMUM_QUICK_LINK_TEXT_LENGTH_EXCEEDED,
    MAXIMUM_TEXT_LENGTH_OF_ONE_QUICK_LINK_HAS_BEEN_EXCEEDED,
    MEMBERSHIP_LIFESPAN_SHOULD_BE_1_90,
    MEMBERSHIP_LIFESPAN_CAN_BE_SET_FOR_GOAL_AND_SEGMENT,
    MINUTES_START_SHOULD_DIV_BY_15,
    MINUTES_END_SHOULD_DIV_BY_15,
    MINUS_KEYWORD_CANNOT_CONTAIN_MORE_THAN_TWO_NUMBERS,
    MINUS_PHRASES_CAN_ONLY_CONSIST,
    MINUS_PHRASES_CANNOT_CONTAIN_MORE_THAN_TWO_NUMBERS,
    MINUS_PHRASES_COULD_NOT_START_WITH_DOT_OR_APOSTROPHE,
    MINUS_PHRASES_LENGHT_MORE_THAN,
    MINUS_PHRASES_UNSUPPORTED_IN_CPM,
    MINIMUM_WARNING_BALANCE_SHOULD_BE,
    MISSING_ELEMENT_OR_BLOCK,
    MISSING_REQUIRED_FIELD,
    MUST_SET_MINIMUM_OS_VERSION,
    MUST_ENTER_LINK_FOR_APP,
    MULTIPLE_NETWORK_STRATEGY_PARAMS,
    MULTIPLE_SEARCH_STRATEGY_PARAMS,
    NAMES_RETARGETING_LISTS_UNIQUE,
    NEED_TO_SET_PRIMARY_DOMAIN_OF_AD_GROUP,
    NEGATIVE_KEYWORDS_CAN_ONLY_CONSIST,
    NETWORK_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS,
    NEW_AND_OLD_IMAGES_MUST_BE_SAME_SIZE,
    NOT_ENOUGH_UNITS_FOR_OPERATION,
    NO_ACCESS_TO_API,
    NOT_ALLOWED_TO_UPDATE_AGE_LABEL,
    NOT_ENOUGH_STATISTICS_DATA_FOR_CONVERSION,
    NOT_SUITABLE_MEANINGFUL_GOALS,
    NO_EFFECT_WALLET_DAY_BUDGET,
    NO_EFFECT_WALLET_DAY_BUDGET_SHOW_MODE,
    NO_FIELDS_IN_SELECTION_CRITERIA,
    NO_MORE_MERTRICA_COUNTERS_CAN_BE_SPECIFIED,
    NO_RETARGERTING_CONDITIONS_FOUND,
    NO_RIGHTS_TO_CREATE_CAMPAIGN,
    NO_RIGHTS_TO_DELETE,
    NO_RIGHTS_TO_SHARED_ACCOUNT_ENABLED,
    NO_RIGHTS_TO_THE_OBJECT,
    NO_RIGHTS_TO_THIS_CLIENT,
    NO_RIGHTS_TO_CREATE_CLIENTS,
    NO_RIGHTS_TO_THIS_USER,
    NO_RIGHTS_TO_WRITE,
    NO_VALUE_IN_FIELD,
    NOT_INDICATED_VALUE_IN_FIELD_MEMBERSHIP_LIFESPAN,
    NOT_ENOUGH_STATISTICAL_CONVERSION_FOR_SPECIFIED_GOAL,
    NOT_ENOUGH_STATISTICAL_CONVERSION_TO_CHANGE_GOAL,
    NOT_POSSIBLE_TO_DELETE_LAST_ACTIVE_KEYWORD,
    NOT_POSSIBLE_TO_STOP_LAST_ACTIVE_KEYWORD,
    NULL_STRING,
    NUMBER_OF_ARGUMENTS_MUST_BE_FROM_TO,
    NUMBER_OF_CLICKS_PER_WEEK_NOT_SPECIFIED,
    NUMBER_OF_DISABLED_SITES_EXCEEDS_ITS_LIMIT,
    NUMBER_OF_ELEMENTS_EXCEEDED,
    NUMNER_OF_RULES_MUST_BE,
    NUMBER_OF_RULES_MUST_BE_FROM_TO,
    NUMBER_OF_QUICK_LINKS_SHOULD_BE_FROM_TO,
    OBJECT_MUST_CONTAIN_FIELD,
    OBJECT_WITH_THESE_CHARACTERISTICS_ALREADY_EXIST,
    OFFSET_MUST_BE_LESS_OR_EQUAL_THAN,
    OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0,
    OFFSET_MUST_BE_MORE_THAN_0,
    OFF_ALL_AUTOTARGETING_CATEGORIES_IS_NOT_ALLOWED,
    ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
    ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
    ONE_OF_PARAMETERS_SHOULD_BE_SPECIFIED,
    ONLY_METRICA_GOALS_FOR_RETARGETING_LISTS_OF_NONE_TYPE,
    ONLY_ONE_AUTOTARGETING_IN_ADGROUP,
    ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
    ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
    ONLY_ONE_OF_FIELDS_CAN_BE_SPECIFIED,
    ONLY_ONE_OF_FIELDS_CAN_BE_SPECIFIED_2,
    ONLY_ONE_OF_THE_CRITERIA_TYPE,
    ONLY_ONE_OF_THE_WEEK_DATE_QUARTER_YEAR_MONTH,
    ONLY_POSITIVE_VALUE_FOR_THIS_PARAMETER,
    ONLY_SEPARATE_WORDS_COULD_BE_EXCLUDED,
    OPERATION_IS_NOT_SET,
    OS_VERSION_ENTERED_INCORRECTLY,
    PARAMS_CONTAINS_UNKNOWN_FIELD,
    PARAMS_MUST_CONTAIN_THE_FIELD,
    PARAM_WILL_NOT_BE_CHANGED,
    PLEASE_PROVIDE_CAMPAIGN_S_NAME,
    PLEASE_PROVIDE_YOU_NAME,
    POSITION_INTERVAL_CAN_ONLY_BE,
    PRIORITY_GOAL_ID_NOT_FOUND,
    PRIORITY_GOAL_VALUE_TOO_BIG,
    PRIORITY_GOAL_VALUE_TOO_SMALL,
    PRIORITY_GOAL_NOT_SUPPORTED_OPERATION,
    PROFITABILITY_SHOULD_BE_IN_INTERVAL,
    REPORTS_UNSUPPORTED_FIELD,
    REPORTS_UNSUPPORTED_FIELD_IN_FIELD_NAMES,
    REPORTS_UNSUPPORTED_FIELD_IN_FIELD_NAMES_WITH_REPORT_TYPE,
    REPORTS_UNSUPPORTED_FIELD_WITH_REPORT_TYPE,
    RETARGETING_LISTS_ADD_LIMIT_EXCEEDED,
    RETARGETING_LISTS_ALREADY_EXISTS_IN_GROUP,
    RETARGETING_LISTS_DELETE_LIMIT_EXCEEDED,
    RETARGETING_LISTS_UPDATE_LIMIT_EXCEEDED,
    RETARGETING_LISTS_UNIQUE,
    RETARGETING_LISTS_USED,
    RULES_IN_CONDITION_MUST_BE_UNIQUE,
    QUICK_LINK_TEXT_NOT_ENTERED,
    QUICK_LINKS_TEXTS_SHOULD_NOT_BE_IDENTICAL,
    QUICK_LINKS_SHOULDNT_LEAD_TO_SAME_SITE_PAGE,
    REGIONAL_ADJUSTMENT_NOT_SUPPORTED_IN_ADGROUP,
    REGION_CANNOT_BE_EXLUDED_FOR_THIS_REQUEST,
    REGION_IS_DULICATED,
    RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY,
    REPORTS_CLICK_TYPE_INCOMPATIBLE,
    REPORTS_CRITERION_FIELD_INCOMPATIBLE,
    REPORTS_DATE_RANGE_OUT_OF_SLIDING_WINDOW,
    REPORTS_PLACEMENT_INCOMPATIBLE,
    REPORTS_OFFLINE_QUEUE_EXCEED,
    RESERVE_RETURN_NOT_SPECIFIED,
    REPORTS_YND_FIXED_VAT_OR_DISCOUNT_MISMATCH,
    REQUESTED_FIELDS_IN_SELECTION_CRITERIA,
    REQUESTED_FIELDS_IN_SELECTION_CRITERIA_IDS,
    REQUIRES_INPUT_DATA_ADDREQUEST_NEGATIVE_KEYWORDS,
    REQUIRES_INPUT_DATA_UPDATEREQUEST_NEGATIVE_KEYWORDS,
    REQUIRED_VALUE_FOR_ELEMENT,
    REQUIRED_VALUE_FOR_ELEMENT_ADDREQUEST_ADGROUPS,
    REQUIRED_VALUE_FOR_ELEMENT_UPDATEREQUEST_ADGROUPS,
    REQUIRED_VALUE_FOR_ELEMENT_SITELINKS_ADD,
    RESERVE_RETURN_SHOULD_BE_IN_INTERVAL_AND_MULTIPLE_OF_TEN,
    RETARGETING_CONDITION_NOT_FOUND,
    RETARGETING_CONDITION_SHOULD_BE_PRESENTED_ONCE,
    RETARGETING_CONDITION_GOALS_NUMBERS_FROM_TO,
    RETARGETING_USER_LIST_NOT_FOUND,
    RETARGETING_LISTS_ID_SHOULD_BE_ONCE_IN_REQUEST,
    AUDIENCE_TARGETS_FOR_OBJECT_NOT_FOUND,
    RETARGETING_LIST_WITH_SAME_NAME_ALREADY_EXIST,
    RETARGETING_LIST_WITH_SAME_RULE_SET_ALREADY_EXIST,
    RETAGETING_LIST_ID_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
    ROI_COEF_SHOULD_BE_GREATER_THAN,
    RULE_SETS_RETARGETING_LISTS_UNIQUE,
    SEARCH_STRATEGY_NAME_MISMATCH_WITH_PARAMETERS,
    SEARCH_QUERY_PERFORMANCE_REPORT_DATE_RANGE_OUT_OF_SLIDING_WINDOW,
    SELECTION_CRITERIA,
    SET_AUTO_DENIED_FOR_AUTOTARGETING,
    SET_BIDS_FOR_ARCHIVED_CAMPAIGN_IS_DENIED,
    SET_EMPTY_VALUE_IN_FIELD,
    SETTING_OS_TYPE_NOT_ALLOWED,
    SETTING_WILL_NOT_BE_CHANGED,
    SITELINKS_ADD_MISSING_ELEMENT_OR_BLOCK,
    SITELINKS_DELETE_MISSING_ELEMENT_OR_BLOCK,
    SITELINKS_GET_MISSING_ELEMENT_OR_BLOCK,
    SITELINKS_MUST_CONTAINS_NO_LESS_THAN_N_ELEMENTS,
    SITELINKS_TEXT_ONLY_FOR_KAZAKHSTAN,
    SITELINKS_TEXT_ONLY_FOR_TURKEY,
    SITELINKS_TEXT_ONLY_FOR_UKRAINE,
    SITELINKS_SET,
    SITELINKS_SET_NOT_FOUND,
    SITELINKS_SET_BUT_MAIN_LINK_NOT_ENTERED,
    SITELINKS_SET_USED_AND_CANT_BE_DELETED,
    SITELINKS_WRONG_TITLE,
    SITELINKS_DESCRIPTION_NOT_ENTERED,
    SOME_ERROR,
    SPACE_CANNOT_BE_USED_IN_NEGATIVE_KEYWORDS,
    SPECIFIED_GOAL_NOT_FOUND,
    ALL_GOALS_OPTIMIZATION_IS_PROHIBITED,
    PAY_FOR_CONVERSIOIN_DOES_NOT_ALLOW_ALL_GOALS_OPTIMIZATION,
    ROI_MEANINGFUL_GOALS_IS_NOT_SET,
    MAX_CONVERSION_RATE_MEANINGFUL_GOALS_IS_NOT_SET,
    MEANINGFUL_GOALS_CANNOT_BE_UNSET,
    SELECTION_OF_ADJUSTMENTS_MAY_NOT_BE_PRESENT_MORE_THAN_ONCE,
    SPECIFIC_SYMBOLS_MUST_NOT_BE_REPEATED,
    START_DATE_CANT_BE_EARLIER_THAN_NOW,
    START_END_HOURS_MUST_BE_ENTERED,
    STRATEGY_NOT_SUPPORTED,
    STRATEGIES_NOT_COMPATIBLE,
    STRATEGY_ON_NETWORK_MUST_CONTAINS_SETTINGS,
    STRATEGY_ON_SEARCH_MUST_CONTAINS_SETTINGS,
    STRATEGY_LOWEST_COST_NOT_AVAILABLE_ANYMORE,
    STRING_FIELD_SHOULD_NOT_BE_EMPTY,
    STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_RMP_CAMPAIGN,
    STORE_URL_MUST_BE_SAME_FOR_RMP_CAMPAIGN,
    SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED,
    SUCH_CONDITION_ALREADY_EXISTS,
    TARGETS_FOR_CAMPAIGN_NOT_FOUND,
    TARGETS_FOR_GROUP_NOT_FOUND,
    THE_FOLLOWING_FIELD_VALUES_AVAILABLE,
    THIS_RETARGETING_LIST_CAN_BE_USED_ONLY_FOR_BID_MODIFIERS,
    THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS,
    THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
    TIME_TARGETING_CANT_CONTAINS_NEGATIVE_COEFS,
    TIME_TARGETING_IS_INCORRECT,
    TIME_TARGETING_HAS_REPEATED_WEEKDAYS,
    TIME_TARGETING_HAS_NOT_INTEGER_COEFS,
    TIME_TARGETING_MUST_CONTAINS_COEFS_FOR_24_HOURS,
    TIME_TARGETING_MUST_CONTAINS_DAYS_FROM_1_TO_7,
    TIME_TARGETING_MUST_CONTAINS_VALUES_DIV_10,
    TIME_TARGETING_COEFS_MUST_BE_FROM_0_TO_200,
    TIME_TARGETING_COEFS_MUST_BE_0_OR_100,
    TYPE_OF_AD_GROUP_NOT_SUPPORTED,
    TOKEN_NOT_SET,
    TOKEN_NOT_FOUND,
    TOTAL_LENGTH_OF_NEGATIVE_KEYWORDS_LONGER_THAN,
    TURBO_PAGE_NOT_FOUND,
    LENGTH_OF_NEGATIVE_KEYWORDS_LONGER_THAN,
    LENGTH_OF_NEGATIVE_PHRASES_LONGER_THAN,
    NUMBER_OF_WORDS_IN_NEGATIVE_KEYPHRASE_GREATER_THAN,
    TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP,
    TIME_FROM_SHOULD_BE_LESS_THAN_TIME_TO,
    UNABLE_DELETED_GROUP_CONTAINED_OBJECTS,
    MAX_UPDATE_ADS_LIMIT_EXCEEDED,
    UNABLE_MODERATE_AD_WITHOUT_SHOW_CONDITIONS,
    UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS,
    UNSUPPORTED_APPLICATION_STORE,
    UPDATE_NO_MORE_THAN,
    UPDATE_NO_MORE_THAN_CAMPAIGNS,
    USES_INADMISSIBLE_CHARACTERS,
    UNABLE_TO_DELETE_ASSOCIATED_IMAGE,
    UNABLE_TO_DELETE_CAMPAIGN,
    UNABLE_TO_DELETE_LINKED_AD_EXTENSION,
    UNABLE_TO_PROCESS_JSON,
    UNABLE_UPDATE_ARCHIVED_CAMPAGN,
    UNARCHIVED_CAMPAIGNS_OVERLIMIT,
    UNSUPPORTED_RETARGETING_TYPE,
    USE_SPECIFIED_ALPHABETS_IN_FIELD,
    USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD,
    USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
    VALUE_CANNOT_BE_PRESENT_IN_AD_EXTENSIONS_MORE_THAN_ONCE,
    VALUE_CANNOT_BE_PRESENT_IN_FIELD_MORE_THAN_ONCE,
    VALUE_MUST_NOT_BE_LESS,
    VALUE_MUST_NOT_BE_MORE,
    VALUE_INVALID_FORMAT_IN_FILED,
    VALUE_OF_RULE_MUST_CONTAIN_SIGNIFICANT_CHARACTERS,
    VALUE_SHOULD_NOT_EXCEED_CHARACTERS,
    VCARD_MISSING_ELEMENT_OR_BLOCK,
    VCARD_NOT_BELONGS_TO_CAMPAIGN,
    VCARD_NOT_FOUND,
    VCARD_IN_DETAILS,
    VCARD_IS_IN_USAGE,
    VIDEO_ADDITION_NOT_FOUND,
    CPC_VIDEO_NOT_FOUND,
    WEBPAGE_ID_IN_REQUEST_MORE_THAN_ONCE,
    WEBPAGE_NOT_FOUND,
    WEBPAGE_NOT_SUSPENDED,
    WEBPAGE_SUSPENDED,
    WEBPAGE_WITH_ALL_CONDITION_CAN_NOT_BE_WITH_ANOTHER_CONDITION,
    WEBPAGES_WITH_THIS_CONDITIONS_ALREADY_EXIST_IN_GROUP,
    WEEKLY_BUDGET_MUST_BE_GREATER_THAN_MAXIMUM_BID,
    WEEKLY_BUDGET_MUST_BE_GREATER_THAN_AVG_CPA_MULTIPLIED_BY_RATIO,
    WEEKLY_BUDGET_MUST_NOT_SPECIFIED,
    WEEKLY_BUDGET_SHOULD_BE_GREATER_THAN_AVERAGE_PRICE,
    WEEKLY_BUDGET_SHOULD_BE_GREATER_THAN_AVERAGE_CPI,
    WEEKLY_LIMIT_IS_TOO_HIGH,
    WEEKLY_LIMIT_SHOULD_BE_MORE_THAN,
    WEEKLY_LIMIT_SHOULD_BE_GREATER_THAN_AVERAGE_CPA,
    WEEKLY_LIMIT_SHOULD_BE_GREATER_THAN_AVERAGE_CPI,
    WEEKLY_LIMIT_SHOULD_BE_GREATER_THAN_MAX_BID,
    WORK_TIME_MINUTES_SHOULD_BE_DIVISIBLE_BY_15,
    WORK_TIME_INTERVAL_FORMAT,
    WRONG_AD_TYPE,
    WRONG_HTTP_PROCESSING_MODE_VALUE,
    WRONG_IP_ADDRESS_FORMAT,
    WRONG_SYMBOLS_IN_SITELINK_DESCRIPTION,
    WRONG_SYMBOLS_IN_SITELINK_TITLE,
    WRONG_VALUE_FOR_THIS_FIELD,
    WRONG_VALUE_FOR_THIS_PARAMETER,
    WRONG_VALUES_FOR_THIS_PARAMETER,
    YOU_CANNOT_BLOCK_PRIVATE_SUBNETWORK_IPS,
    YOU_CANNOT_CHANGE_NONE_PROPERTY,
    YOU_CANNOT_CHANGE_ANY_OF_NONE_PROPERTY,
    YOU_CAN_MODERATE_ONLY_DRAFT_AD,
    YOU_CAN_BLOCK_ONLY_THIRD_LEVEL,
    YOU_MUST_FILL_REQUEST_AND_WAIT_CONFIRMATION,
    YOU_MUST_FIRST_UNARCHIVE_CAMPAIGN,
    YOU_MUST_SPECIFY_CLIENT_LOGIN,
    FLAT_CPC_STRATEGY_NOT_SUPPORTED,

    EXPIRED_OAUTH_TOKEN,
    ABSENT_OAUTH_TOKEN,
    INVALID_OAUTH_TOKEN_FORMAT,
    UNKNOWN_LOGIN_IN_CLIENT_LOGIN,
    NOT_CLIENT_IN_CLIENT_LOGIN,

    ACCOUNT_BLOCKED,
    ACCESS_DENIED_NOT_ALLOWED_IP,
    ACCESS_DENIED_WHILE_CONVERTING_CURRENCY,
    ACCESS_DENIED_FOR_YA_AGENCY,

    STRATEGY_NO_PREMIUM_DEPRECATED;

    private static String BUNDLE = "api.Api5ErrorDetails";
    private String locale = "en";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }

}
