package ru.yandex.autotests.directapi.apiclient.errors;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Ключи, по которым хранятся детальные сообщения о ошибках java-direct-приложений
 */
public enum Api5ErrorDetailsJava implements ITextResource {
    ACCOUNT_BLOCKED,
    AD_EXTENSION_ID_PRESENT_MORE_THAN_ONCE_IN_REQUEST,
    AD_EXTENSION_IS_MARKED_AS_DELETED,
    AD_EXTENSION_NOT_LINKED,
    AD_EXTENSION_NOT_FOUND_NO_ID,
    AD_IS_DRAFT_AND_CANT_BE_ARCHIVED,
    AD_MORE_THAN_ONCE_IN_REQUEST,
    AD_MUST_CONTAIN_VCARD_OR_MAIN_HREF,
    AD_NOT_FOUND,
    ADEXTENSIONS_ARRAY_CANNOT_CONTAIN_MORE_THAN,
    ADGROUP_TYPE_NOT_SUPPORTED,
    ARRAY_CANNOT_CONTAIN_MORE_THAN,
    ARRAY_CONTAINS_NULL,
    AUDIENCE_TARGETS_ADD_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_ADGRPOUP_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_CPM_ADGRPOUP_LIMIT_EXCEEDED,
    AUDIENCE_TARGETS_FOR_PARAMETERS_NOT_FOUND,
    AUDIENCE_TARGETS_SET_BIDS_LIMIT_EXCEEDED,
    BANNER_OLD_PRICE_LOWER_THAN_NEW,
    BANNER_CURRENCY_MISSING,
    BANNER_PRICE_MISSING,
    BID_MODIFIER_SET_NOT_FOUND,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_NETWORK_DEPENDS_ON_SEARCH,
    BID_NETWORK_WILL_NOT_APPLIED_BECAUSE_OF_NETWORK_DEPENDS_ON_SEARCH,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_CONTEXT,
    BID_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_SEARCH,
    BID_SEARCH_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_SEARCH,
    CALLOUT_TEXT_IS_EMPTY,
    CALLOUT_TEXT_TEXT_SIZE_EXCEEDED,
    CAMPAIGN_IN_DETAILS,
    CAMPAIGN_TYPE_NOT_SUPPORTED,
    CAN_NOT_DELETE_PATH_AND_VALUE,
    CAN_NOT_DELETE_VALUE_ONLY,
    CANT_UPDATE_AD_IN_ARCHIVED_CAMPAIGN,
    CANT_UPDATE_ARCHIVED_AD,
    CONTACT_INFO_COUNTRY_CODE_MUST_START_FROM,
    CONTACT_INFO_COUNTRY_CODE_WITH_CITY_CODE_SHOULD_NOT_START_WITH_PLUS,
    CORRECT_DATE_MUST_BE_SPECIFIED,
    COULD_NOT_ADD_VCARD_TO_ARCHIVED_CAMPAIGN,
    COUNTRY_CODE_MUST_START_WITH_PLUS,
    DENIED_ADD_AD_TO_ARCHIVED_CAMPAIGN,
    DUPLICATED_ID_ELEMENT,
    DUPLICATED_OBJECT,
    DUPLICATED_OBJECT_NAME,
    DUPLICATED_OBJECT_RULES,
    OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
    EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED,
    ELEMENT_OF_ARRAY_CANT_HAVE_NULL_VALUE,
    ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
    ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
    ELEMENT_OF_ARRAY_MUST_BE_POSITIVE_INTEGER,
    ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
    ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME_WITHOUT_LIST,
    EMPTY_AREA_CODE,
    EMPTY_COUNTRY_CODE,
    EMPTY_HREF,
    EMPTY_SITELINK_HREF,
    EMPTY_PHONE_NUMBER,
    EMPTY_VALUE,
    ENABLE_DELETE_NO_MORE_ADS_FOR_OPERATION,
    ENABLE_DELETE_NO_MORE_ADEXTENSIONS_FOR_OPERATION,
    ENABLE_DELETE_NO_MORE_AUDIENCE_TARGETS_FOR_OPERATION,
    ENABLE_DELETE_NO_MORE_RETARGETING_LISTS_FOR_OPERATION,
    ENABLE_DELETE_NO_MORE_SITELINKS_FOR_OPERATION,
    ENABLE_DELETE_NO_MORE_VCARDS_FOR_OPERATION,
    FIELD_MAXIMUM_LENGTH_EXCEEDED,
    FIELD_MUST_BE_IN_RANGE_FROM_TO,
    FIELD_MUST_BE_POSITIVE_INTEGER,
    FIELD_MUST_CONTAIN_ARRAY,
    FIELD_MUST_CONTAIN_INTEGER_VALUE,
    FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
    FIELD_MUST_CONTAIN_STRING,
    FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
    FIELD_MUST_NOT_CONTAIN_ARRAY,
    FIELD_VALUE_SHOULD_NOT_BE_MORE_THAN,
    FORBIDDEN_AGENCY_FIELDS_ONLY,
    GROUP_NAME_CANNOT_CONTAIN_255_SYMBOLS,
    GROUP_NOT_FOUND,
    ID_MUST_BE_POSITIVE_INTEGER,
    IN_AUDIENCE_TARGET_CAN_BE_USED_ONLY_INTEREST_IS_TARGETABLE_YES,
    IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
    IN_STRUCTURE_MUST_BE_ONE_OF_REQUIRED_FIELD,
    INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS,
    INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE,
    INCORRECT_ENUMERATE_VALUE,
    INCORRECT_ENUMERATE_VALUE_IN_ARRAY,
    INCORRECT_USE_OF_SYMBOL_IN_KEYWORD,
    INVALID_AREA_CODE_FORMAT,
    INVALID_CHARS,
    INVALID_CONTACT_EMAIL_FORMAT,
    INVALID_COUNTRY_CODE_FORMAT,
    INVALID_IM_LOGIN_ICQ,
    INVALID_IM_LOGIN_MAIL_AGENT,
    INVALID_IM_LOGIN_SKYPE,
    INVALID_LIST_SIZE,
    INVALID_METHOD_VALUE,
    INVALID_METRO_STATION,
    INVALID_PHONE_EXTENSION_FORMAT,
    INVALID_PHONE_NUMBER_FORMAT,
    INVALID_REQUEST_FORMAT,
    INVALID_TYPE,
    INVALID_VALUE,
    INVALID_VALUE_IN_FIELD,
    INVALID_VALUE_IN_FIELD2,
    INVALID_VALUE_PATH_AND_VALUE,
    INVALID_VALUE_VALUE_ONLY,
    KEYWORD_INCORRECT_USAGE_OF_QUOTES,
    KEYWORD_MAX_LENGTH_EXCEEDED,
    LENGTH_OF_NEGATIVE_KEYWORDS_LONGER_THAN,
    LINK_HAS_EXCEEDED_CHARACTER_LIMIT,
    LOGIN_NOT_MATCH_TOKEN,
    MAX_FOREIGN_PIXELS_ON_BANNER,
    MAX_IDS_IN_SELECTION,
    MAX_NUMBER_OF_NARROW_CHARACTERS_IN_FIELD_EXCEEDED,
    MAX_OBJECTS,
    MAX_STR_LENGTH,
    MAX_YA_AUD_PIXELS_ON_BANNER,
    MAXIMUM_NUMBER_OF_ADS_IN_GROUP_REACHED,
    MAXIMUM_GROUPS_IN_CAMPAIGN_REACHED,
    MEMBERSHIP_LIFESPAN_CAN_BE_SET_FOR_GOAL_AND_SEGMENT,
    MEMBERSHIP_LIFESPAN_MUST_BE_SET_FOR_GOAL_AND_SEGMENT,
    MINUS_KEYWORDS_NOT_ALLOWED,
    MINUS_WORDS_WITH_RETARGETING_NOT_ALLOWED,
    MISSED_REQUIRED_PARAMETER_IN_SELECTION,
    MISSING_PARAMETER_VALUE,
    MISSING_VALUE,
    MISSING_VALUE_OR_NULL,
    NO_RIGHTS,
    NO_RIGHTS_FOR_AGENCY_SERVICE,
    NO_RIGHTS_FOR_CLIENT,
    NO_RIGHTS_TO_AUDIENCE_PIXEL,
    NO_RIGHTS_TO_PIXEL,
    TOO_MANY_PIXELS_OF_SAME_PROVIDER,
    NO_VALUE_IN_FIELD,
    NOT_CLIENT_IN_CLIENT_LOGIN,
    NOT_ENOUGH_UNITS,
    NOT_FOUND,
    NOT_FOUND_PATH_AND_VALUE,
    NOT_FOUND_VALUE_ONLY,
    OBJECT_EXISTS,
    ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
    ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_FOR_STRATEGY,
    ONE_OF_PIXEL_PROVIDERS_IS_NOT_ALLOWED_FOR_CLIENT,
    INVALID_PIXEL_FORMAT,
    ONLY_METRICA_GOALS_FOR_NEGATIVE_CONDITIONS,
    ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
    ONLY_ONE_OF_FIELDS_CAN_BE_SPECIFIED,
    OPERATION_IS_NOT_SET,
    REQUIRED_FIELD,
    RETARGETING_LISTS_ALREADY_EXISTS_IN_GROUP,
    RETARGETING_LISTS_ID_SHOULD_BE_ONCE_IN_REQUEST,
    RETARGETING_LISTS_UNIQUE,
    RETARGETING_SCOPE_IS_CONSTANT,
    SET_EMPTY_VALUE_IN_FIELD,
    SITELINKS_SET_BUT_MAIN_LINK_NOT_ENTERED,
    SITELINKS_SET_USED_AND_CANT_BE_DELETED,
    STRATEGY_PRORITY_NOT_USED_FOR_MANUAL_STRATEGY,
    SPECIAL_CHARS_MUST_NOT_BE_REPEATED,
    SQUARE_BRACKETS_COULD_NOT_BE_EMPTY_OR_EMBEDDED,
    THIS_RETARGETING_LIST_CAN_BE_USED_ONLY_FOR_BID_MODIFIERS,
    THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
    TRACKING_URL_DOESNT_CONTAIN_MACROS,
    TYPE_OF_AD_GROUP_NOT_SUPPORTED,
    UNABLE_TO_DELETE_LINKED_AD_EXTENSION,
    UNABLE_TO_UPDATE_ARCHIVED_CAMPAIGN,
    UNACCEPTABLE_SYMBOLS_USED_IN_SQUARE_BRACKETS,
    UNKNOWN_FIELD,
    UNKNOWN_PARAMETER,
    USE_SPECIFIED_ALPHABETS_IN_FIELD,
    USE_SPECIFIED_ALPHABETS_NUMBERS_AND_PUNCTUATION_IN_FIELD_EN,
    USERNAME_DOES_NOT_EXIST,
    VALUE_INVALID_FORMAT_IN_FILED,
    VALUE_MUST_NOT_BE_LESS,
    VALUE_MUST_NOT_BE_LESS_WITHOUT_CURRENCY,
    VALUE_MUST_NOT_BE_MORE,
    VALUE_MUST_NOT_BE_GREATER_THAN,
    VALUE_MUST_BE_GREATER_THAN,
    VCARD_IN_DETAILS,
    VCARD_IS_IN_USAGE,
    WORK_TIME_INTERVAL_FORMAT,
    WORK_TIME_MINUTES_SHOULD_BE_DIVISIBLE_BY_15,
    YOU_MUST_FILL_REQUEST_AND_WAIT_CONFIRMATION,
    REGION_IS_DUPLICATED,
    INVALID_OR_NONEXISTENT_REGION,
    REGION_CANNOT_BE_EXLUDED_FOR_THIS_REQUEST,
    COEFFICIENT_VALUE_MUST_BE_A_POSITIVE_INTEGER,
    ADJUSTMENT_OF_THIS_TYPE_IS_NOT_SUPPORTED,
    CAMPAIGN_NOT_FOUND,
    UNABLE_UPDATE_ARCHIVED_CAMPAGN,
    REGIONAL_ADJUSTMENT_NOT_SUPPORTED_IN_ADGROUP,
    ENABLE_GEO_ONLY_FOR_UKRAINE,
    ENABLE_GEO_ONLY_FOR_TURKEY,
    ENABLE_GEO_ONLY_FOR_KAZAKHSTAN,
    ALL_REGIONS_CANNOT_BE_EXCLUDED,
    REGION_IS_DULICATED,
    REQUIRED_PARAMS_MISSED,
    EXPIRED_OAUTH_TOKEN,
    TYPE_OF_AD_DOES_NOT_CORRESPOND_TO_GROUP_EN,
    SIZE_CANNOT_BE_MORE_THAN_MAX,
    NONEXISTENT_REGION_IDS,
    MINUS_WORD_CANT_SUBTRACT_PLUS_WORDS,
    ONLY_SEPARATE_MINUS_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORD,
    KEYWORD_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY,
    ONLY_SEPARATE_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORD_PHRASES,
    NO_MODIFIERS_INSIDE_SQUARE_BRACKETS,
    KEYWORD_COULD_NOT_CONTAIN_MORE_WORDS,
    KEYWORD_MAX_LENGTH_EXCEEDED_INDIVIDUAL,
    KEYWORD_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY,
    INCORRECT_USE_OF_DOT_IN_KEYWORD,
    INCORRECT_USE_OF_BRACKETS_IN_KEYWORD,
    BOTH_QUOTES_AND_MINUS_WORDS_IN_KEYWORD,
    MINUS_WORD_CANT_SUBTRACT_PLUS_WORDS_IN_KEYWORDS,
    ONLY_SEPARATE_MINUS_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORDS,
    KEYWORDS_COULD_NOT_CONSIST_OF_NEGATIVE_KEYWORDS_ONLY,
    ONLY_SEPARATE_WORDS_CAN_BE_EXCLUDED_FROM_KEYWORDS_PHRASES,
    BOTH_QUOTES_AND_MINUS_WORDS_IN_KEYWORDS,
    NO_MODIFIERS_INSIDE_SQUARE_BRACKETS_IN_KEYWORDS,
    INCORRECT_USE_OF_SYMBOL_IN_KEYWORDS,
    INCORRECT_USE_OF_BRACKETS_IN_KEYWORDS,
    KEYWORDS_COULD_NOT_CONTAIN_MORE_WORDS,
    KEYWORDS_COULD_NOT_CONSIST_OF_STOPWORDS_ONLY,
    INCORRECT_USE_OF_QUOTES_IN_KEYWORDS,
    INCORRECT_USE_OF_DOT_IN_KEYWORDS,
    SITELINKS_WITH_SITELINK_FIELD_NAMES_PROHIBITED,
    ONE_OF_HREF_OR_TURBOLANDING_ID_MUST_BE_NOT_NULL,
    MINUS_PHRASES_CAN_ONLY_CONSIST,
    AVERAGE_CPC_SHOULD_NOT_BE_MORE_THAN_WEEK_BUDGET,
    MUST_BE_LESS_THAN_OR_EQUAL_TO_WEEKLY_BUDGET,
    HOLIDAY_BID_PERCENT_OUT_OF_RANGE,
    FIXED_PERIOD_BUDGET_CANNOT_BE_LESS_WITHOUT_CURRENCY,
    FIXED_PERIOD_BUDGET_CANNOT_BE_MORE_WITHOUT_CURRENCY,
    CAMPAIGN_WILL_NOT_BE_SENT_TO_SERVING,
    MAX_ELEMENTS_EXCEEDED_DETAILED
    ;

    private static String BUNDLE = "api.Api5ErrorDetailsJava";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }
}
