package ru.yandex.autotests.directapi.apiclient.errors;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Author pavryabov
 * Date 18.07.14
 * Список ключей к описаниям ошибок API5.
 * Тексты ошибок содержатся в ресурсах локализации
 *
 * Для добавления воспользоваться ссылкой: https://direct-handles.qart.yandex-team.ru/testdata/textResourceActions.html
 * пример ключа: api.Api5ErrorMessage.LIMIT_ACCESS
 *
 * @see /APIAxisErrorMessage
 */
public enum Api5ErrorMessage implements ITextResource {
    ACCOUNT_BLOCKED,
    AUTHORIZATION_ERROR,
    AUTOTARGETING_ALREADY_SUSPENDED,
    AUTOTARGETING_HAS_NOT_BEEN_STOPPED,
    ARRAY_MUST_CONTAIN_AT_LEAST_ONE_ELEMENT,
    ARRAY_MUST_CONTAIN_AT_LEAST_ONE_FIELD,
    ARCHIEVED_OBJECT_EDIT_NOT_ALLOWED,
    AD_HAS_ALREADY_ARCHIVED,
    AD_HAS_ALREADY_RESUMED,
    AD_HAS_ALREADY_SUSPENDED,
    AD_NOT_ARCHIVED,
    BID_CAN_NOT_CHANGED,
    BID_IS_WRONG,
    BID_WILL_NOT_APPLIED,
    CAMPAIGN_NOT_FOUND,
    CANT_CREATE_LOGIN,
    CANT_PROCESS_REPORT_IN_ONLINE_MODE,
    CREATE_NO_MORE_THAN_100_GROUPS_IN_ONE_REQUEST,
    COULD_NOT_ARCHIVE_OBJECT,
    COULD_NOT_UNARCHIVE_OBJECT,
    DAILY_BUDGET_IS_RESET,
    ELEMENT_CANT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
    EXCEEDED_OBJECTS_LIMIT_FOR_OPERATION,
    EXCEED_LIMIT_CONNECTIONS,
    EXCEED_LIMIT_OF_REQUESTS,
    EXCEEDED_OBJECTS_QUEUE,
    FIELD_NOT_MATCH_STRATEGY,
    FIELD_NOT_PASSED,
    FIELD_SET_INCORRECTLY,
    GROUP_CONTAIN_OBJECTS,
    GROUP_NAME_CANNOT_BE_EMPTY,
    IMPRESSIONS_ARE_RESTRICTED_IN_SEVERAL_REGIONS,
    IN_ONE_REQUEST_SHOULD_BE_ONE_TYPE_ID,
    INCOMPATIBLE_OPERATIONS_IN_ONE_REQUEST,
    INCOMPLETE_REGISTRATION,
    INCONSISTENT_OBJECT_STATE,
    INCORRECT_USE_OF_NEGATIVE_KEYWORDS,
    INCORRECT_USE_OF_STOPWORD,
    INVALID_ACTION,
    INVALID_GEOTARGETING,
    INVALID_GEO_DATA_TO_DISPLAY_A_MAP,
    INVALID_FORMAT,
    INVALID_LIMIT,
    INVALID_OBJECT_STATUS,
    INVALID_OFFSET,
    INVALID_PARAMETERS_OF_PAGE,
    INVALID_REQUEST_FORMAT,
    INVALID_REQUEST,
    INVALID_REQUEST_PARAMETERS,
    INVALID_REQUEST_PARAMETERS_JAVA,
    INVALID_SELECTION_CRITERIA,
    INVALID_TRACKING_URL,
    INVALID_USE_OF_FIELD,
    KEYWORD_ALREADY_SUSPENDED,
    KEYWORD_CONTAINS_TOO_MANY_WORDS,
    KEYWORD_DUPLICATES,
    KEYWORD_HAS_NOT_BEEN_STOPPED,
    KEYWORD_LENGTH_EXCEEDED,
    KEYWORD_MINUS_WORD_LENGTH_EXCEEDED,
    KEYWORD_NOT_FOUND,
    KEYWORD_WAS_CREATED_USING_UPDATE,
    KEYWORDS_OVERLIMIT,
    LANGUAGE_DOESNT_MATCH_GEOTARGETING,
    LOGIN_NOT_SWITCHED_ON_TO_DIRECT,
    LOGIN_IS_IN_USE,
    LOGIN_IS_OCCUPIED,
    MANDATORY_FIELD,
    MAXIMUM_LENGTH_EXCEEDED,
    MAXIMUM_NUMBER_OF_OBJECTS_REACHED,
    MAX_FILE_SIZE_EXCEEDED,
    MORE_THEN_ONE_FIELD_PASSED,
    MUTUALLY_EXCLUSIVE_PARAMETERS,
    NAME_LENGTH_CANNOT_BE_MORE_THAN_255,
    NEGATIVE_KEYWORD_CANNOT_BE_PHRASE,
    NO_EFFECT,
    NO_ACCESS_TO_API,
    NO_ACCESS_TO_API_JAVA,
    NO_ACCESS_TO_METHOD,
    NO_ONE_OF_REQUIRED_FIELDS,
    NO_ONE_OF_REQUIRED_PARAMETERS,
    NOT_ENOUGH_RIGHTS,
    NOT_ENOUGH_UNITS,
    NOT_POSSIBLE_TO_DELETE_OBJECT,
    NOT_POSSIBLE_TO_PAUSE_IMPRESSIONS,
    NOT_SUPPORTED,
    LIMIT_ACCESS,
    NUMBER_OF_PERMITED_ELEMENTS_EXCEEDED_OR_EQUALS_ZERO,
    OBJECT_ALREADY_ARCHIVED,
    OBJECT_ALREADY_EXISTS,
    OBJECT_ALREADY_SUSPENDED,
    OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
    OBJECT_IS_MARKED_AS_DELETED,
    OBJECT_IS_MARKED_AS_DELETED_JAVA,
    OBJECT_IS_PRESENTED_MORE_THAN_ONCE_IN_REQUEST,
    OBJECT_WITH_SUCH_PARAMS_ALREADY_EXISTS,
    OBJECT_NOT_ARCHIVED,
    OBJECT_NOT_FOUND,
    OBJECT_NOT_SUSPENDED,
    OBJECTS_ALREADY_LINKED,
    OBJECTS_NOT_LINKED,
    OPERATION_ERROR,
    OPERATION_NOT_FOUND,
    PRIORITY_WILL_NOT_CHANGED,
    PARAM_WILL_NOT_BE_CHANGED,
    REPEATING_ELEMENT,
    REGION_DOESNT_MATCH_ADS_TEXT,
    PUT_MORE_THAN_ONE_PARAMETER,
    RELEVANT_KEYWORDS_DISABLED,
    SET_EMPTY_VALUE,
    SETTING_WILL_NOT_BE_CHANGED,
    SITELINKS_DUPLICATES,
    SITELINKS_SET_USED_AND_CANT_BE_DELETED,
    TOO_WIDE_SELECTION_CRITERIA,
    TRACKING_URL_DOESNT_CONTAIN_LOGID,
    UNABLE_DELETE_OBJECT,
    UNSUPPORTED_APPLICATION_STORE,
    USES_INADMISSIBLE_CHARACTERS,
    VCARD_DUPLICATES,
    VCARD_IS_IN_USAGE,
    WEBPAGE_NOT_SUSPENDED,
    WEBPAGE_SUSPENDED,
    WRONG_OBJECT_TYPE;

    private static String BUNDLE = "api.Api5ErrorMessage";
    private String locale = "en";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }
}
