package ru.yandex.autotests.directapi.apiclient.errors;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getKey;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 03.08.11
 * Time: 15:12
 * Список ключей к описаниям ошибок.
 * Тексты ошибок содержатся в ресурсах локализации
 *
 * @see /APIAxisError
 */
public enum AxisErrorDetails implements ITextResource {
    TEST,
    A_NEGATIVE_KEYWORD_CAN_ONLY_CONSIST_OF,
    ACCESS_DENIED,
    ACCESS_DINIED_SUB_CLIENTS,
    ACCESS_TO_API_DINIED_FOR_AGENCY_CLIENTS,
    ACCOUNT,
    ACCOUNT_ENABLING_POSSIBLE_NOT_EARLIER_THAN_ONE_DAY_SINCE_LAST_TRY,
    ACCOUNTS_MUST_BE_DIFFERENT,
    ACTION_INVALID,
    ACTIVE_BANNERS_NOT_FOUND,
    ACTIVE_PHRASES_NOT_FOUND,
    ADGROUP_MOBILE_BID_ADJUSTMENT_MUST_BE_INTEGER,
    ADGROUP_TYPE_DOESNT_SUPPORT,
    AD_GROUP_ID,
    AD_GROUP_NAME_MUST_BE_UNIQUE,
    AD_GROUP_ID_DOESNT_MATCH_CAMPAIGNID,
    AD_HAS_BEEN_ARCHIVED,
    ADS_NOT_FOUND,
    ADS_SHALL_BE_DISPLAYED,
    AGENCY_STATUS_VALUES,
    ALLOWED_SET_BIDS_ONLY_FOR_NONARCHVIED_BANNERS,
    ANY,
    ANY_FIELD,
    ALL_AMOUNTS_MUST_BE_IN_THE_SAME_CURRENCY,
    ALL_BANNERS_OF_AD_GROUP_ARE_ARCHIVED,
    AMOUNT_IN_CAMPAIGN_HAS_BEEN_ENTERED_INCORRECTLY,
    API_USAGE_NOT_ALLOWED_DURING_CONVERTATION,
    ARRAY,
    ARRAY_REGIONIDS,
    ARRAY_MUST_CONTAIN_POSITIVE_INTEGER_VALUES,
    ARRAY_MUST_CONTAIN_INTEGER_VALUES,
    ARRAY_MUST_CONTAIN_VALUES,
    ARRAY_SHOULD_CONTAIN_VALUES,
    ARRAY_SHOULD_CONTAIN_UNSIGNED_INTEGER_VALUE,
    ASSIGNED_IMAGES_COULD_NOT_BE_DELETED,
    AUDIENCE_COVERAGE_VALUE_SPECIFIED_INCORRECTLY,
    AUTH_ERROR,
    AUTOBUDGET_CAMPAIGN,
    AUTOBUDGETPRIORITY_VALUES,
    AVERAGE_CPA_SHOULD_NOT_BE_LESS_THAN,
    AVERAGE_CPA_SHOULD_NOT_BE_LESS_THAN_CURRENCY,
    BANNER_BELONGS_TO_ANOTHER_GROUP,
    BANNERID_CANNOT_BE_USED_MORE_THAN_ONCE_IN_REQUEST,
    BANNERIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_1000_ELEMENTS,
    BANNERIDS_MUST_NOT_BE_EMPTY,
    BANNERIDS_OR_CAMPAIGNIDS_MUST_NOT_BE_EMPTY,
    CAMPAIGNIDS_ARRAY_MAX_SIZE,
    BANNERINFO_CONTACTINFO_MUST_BE_STRUCTURE,
    BANNERINFO_SITELINKS_MUST_BE_ARRAY,
    BANNERINFO_SITELINKS_MUST_BE_STRUCTURE_ARRAY,
    BANNERPHRASEINFO_CONTEXTPRICE_FIELD,
    BANNERPHRASEINFO_CONTEXTPRICE_FIELD_MUST_NOT_BE_EMPTY,
    BANNERPHRASEINFO_CONTEXTPRICE_FIELD_ZERO,
    BANNERPHRASEINFO_PHRASE_BRACKETS_EMPTY_OR_INCLUDED,
    BANNERPHRASEINFO_PHRASE_BRACKETS_INCLUDE_INVALID_MODIFIERS,
    BANNERPHRASEINFO_PHRASE_BRACKETS_INCORRECT_USE,
    BANNERPHRASEINFO_PHRASE_CANNOT_CONTAIN_ONLY_STOPWORDS,
    BANNERPHRASEINFO_PHRASE_MINUS_INCORRECT_USE,
    BANNERPHRASEINFO_PHRASE_MINUS_KEYWORD_INCORRECT,
    BANNERPHRASEINFO_PHRASE_PLUS_INCORRECT_USE,
    BANNERPHRASEINFO_PHRASE_QUOTES_INCORRECT_USE,
    BANNERPHRASEINFO_PRICE_FIELD,
    BANNERIDS_ARRAY_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    BANNERSTYPE_INVALID_VALUE,
    BANNERS_AMOUNT_IN_REQUEST_SHOULD_NOT_BE_GREATE_THAN,
    BANNERS_ARCHIVED,
    BANNERS_HAVE_BEEN_DELETED,
    BANNERS_KEYWORD_MINUS_WORD_LENGTH_EXCEEDED,
    BANNERS_KEYWORD_PHRASE_LENGTH_EXCEEDED,
    BANNERS_KEYWORD_PLUS_WORD_LENGTH_EXCEEDED,
    BANNERS_NOT_FOUND,
    BANNER_NO_VALID_CURRENCY_VALUE,
    BANNER_VALID_CURRENCY_VALUE_IS,
    BANNER_ARCHIVED,
    BANNER_CANNOT_BE_DELETED,
    BANNER_ERROR_IN_PRICE_FIELD_LOW_PRICE,
    BANNER_ERROR_IN_PRICE_FIELD_HIGH_PRICE,
    BANNER_FILTER_TAGS_OR_TAGIDS_SHOULD_BE_SET,
    BANNER_IN_CAMPAIGN_ARCHIVED,
    BANNER_LIMIT_EXCEEDED_IN_CAMPAIGN,
    BANNER_MUST_BE_DRAFT,
    BANNER_NOT_FOUND,
    BANNER_TEXT_WORD_OVERLENGTH,
    BANNER_TITLE_WORD_OVERLENGTH,
    BANNER_TYPE_NOT_SUPPOTED,
    BANNER_TYPE_NOT_SUPPOTED_BANNERS,
    BID_GREATER_THAN,
    BID_ENTERED_LOWER_THAN_THE_COST_PER_CLICK,
    CALL_TO_SUPPORT_TO_ENABLE_SHARED_ACCOUNT,
    CAMPAIGN_CREATION_REQUIRED_FOR_ACCOUNT_ENABLING,
    CAMPAIGN_MUST_BE_STOPPED_BEFORE_ARCHIVATION,
    CAMPAIGN_MUST_BE_STOPPED_BEFORE_BEING_ARCHIVED,
    CAMPAIGNIDS_MUSTBE_ARRAY,
    CAMPAIGNIDS_MUSTNOT_BE_EMPTY,
    CAMPAIGNID_INVALID,
    CAMPAIGNID_NOT_FOUND,
    CAMPAIGNID_FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    CAMPAIGNINFO_BIDCOEFS_CANNOT_BE_EMPTY,
    CAMPAIGNINFO_BIDCOEFS_INCORRECT,
    CAMPAIGNINFO_BIDCOEFS_MUSTBE_ARRAY,
    CAMPAIGNINFO_CONTEXTSTRATEGY_CONTEXTLIMITSUM_INVALID,
    CAMPAIGNINFO_CONTEXTSTRATEGY_CONTEXTLIMIT_INVALID,
    CAMPAIGNINFO_CONTEXTSTRATEGY_CONTEXTPRICEPERCENT_INVALID,
    CAMPAIGNINFO_CONTEXTSTRATEGY_MUST_NOT_BE_EMPTY,
    CAMPAIGNINFO_CONTEXTSTRATEGY_STATUSCONTEXTSTOPFIELD,
    CAMPAIGNINFO_CONTEXTSTRATEGY_STRATEGYNAME_INVALID,
    CAMPAIGNINFO_DAYS_CANNOT_BE_EMPTY,
    CAMPAIGNINFO_DAYS_CANNOT_BE_UNSIGNED,
    CAMPAIGNINFO_DAYS_INCORRECT,
    CAMPAIGNINFO_DAYS_MUSTBE_ARRAY,
    CAMPAIGNINFO_FEW_ADD_HOURS,
    CAMPAIGNINFO_FINISHDATE_FIELD,
    CAMPAIGNINFO_FINISHDATE_MUST_BE_GREATER,
    CAMPAIGNINFO_HOURS_BIDCOEFS_DUPLICATE_DATA,
    CAMPAIGNINFO_HOURS_BIDCOEFS_LENGTH_NOT_EQUAL,
    CAMPAIGNINFO_HOURS_CANNOT_BE_EMPTY,
    CAMPAIGNINFO_HOURS_SHOULD_CONTAIN_UNSIGNED_INTEGERS,
    CAMPAIGNINFO_HOURS_INCORRECT,
    CAMPAIGNINFO_HOURS_MUSTBE_ARRAY,
    CAMPAIGNINFO_STRATEGY_CONTEXTSTRATEGY_INVALID_COMBINATION,
    CAMPAIGNINFO_STRATEGY_STRATEGYNAME_INVALID,
    CAMPAIGNINFO_STRATEGY_STRATEGYNAME_ON_DEFAULT_CONTEXT_INVALID,
    CAMPAIGNINFO_STRATEGY_STRATEGYNAME_ON_DEFAULT_CONTEXT_INVALID_LIVE,
    CAMPAIGNINFO_TIMETARGET_DAYS_INCORRECT,
    CAMPAIGNINFO_TIMETARGET_HOURS_INCORRECT,
    CAMPAIGNINFO_TIMETARGET_INCORRECT,
    CAMPAIGNSTRATEGY_AVERAGEPRICE_FIELD_MUSTBE_GREATER_THAN_MIN,
    CAMPAIGNSTRATEGY_AVERAGEPRICE_FIELD_MUSTBE_GREATER_THAN_ZERO,
    CAMPAIGNSTRATEGY_BIDS_EXCEEDED,
    CAMPAIGNSTRATEGY_BUDGET_MUSTBE_GREATER_THEN_10,
    CAMPAIGNSTRATEGY_CLICKSPERWEEK_EXCEEDED,
    CAMPAIGNSTRATEGY_CLICKSPERWEEK_MUSTBE_GREATER_THAN_ZERO,
    CAMPAIGNSTRATEGY_CLICKSPERWEEK_WRONG,
    CAMPAIGNSTRATEGY_CPC_EXCEEDED,
    CAMPAIGNSTRATEGY_STRATEGYNAME_INVALID_IN_4,
    CAMPAIGNSTRATEGY_MAXPRICE_FIELD_MUSTBE_GREATER_THAN_ZERO,
    CAMPAIGNSTRATEGY_NOT_ENOUGH_CONVERSION_DATA,
    CAMPAIGNSTRATEGY_STRATEGYNAME_INVALID,
    CAMPAIGNSTRATEGY_TARGET_NOT_FOUND,
    CAMPAIGNSTRATEGY_WEEKLYBUDGET_EXCEEDED,
    CAMPAIGNSTRATEGY_WEEKLYBUDGET_MUSTBE_GREATER_THEN_10,
    CAMPAIGNSTRATEGY_WEEKLYSUMLIMIT_MUSTBE_GREATER_THAN_ZERO,
    CAMPAIGN_ARCHIVED,
    CAMPAIGN_ARCHIVED_PAYMENT_IMBOSSIBLE,
    CAMPAIGN_ARCHIVED_WITH_ID,
    CAMPAIGN_ARCHIVED_AND_CANNOT_BE_EDITED,
    CAMPAIGN_AT_FIRST_HELP,
    CAMPAIGN_DOESNT_BELONG_CLIENT,
    CAMPAIGN_ID,
    CAMPAIGN_INVALID,
    CAMPAIGN_INVALID_PARAMETRIZED,
    CAMPAIGN_NOT_EXIST,
    CAMPAIGN_NOT_MODERATE,
    CAMPAIGN_NOT_MODERATED,
    CAMPAIGN_MUST_REMOVED_FROM_ARCHIVE,
    CAMPAIGN_STRATEGY_STRATEGYNAME_INVALID,
    CAMPAIGN_CONTEXT_STRATEGY_STRATEGYNAME_INVALID,
    CANNOT_DELETE_ADS_IN_ARCHIVED_CAMPAIGN,
    CANNOT_RECEIVE_STATISTICS_MORE_THAN_PER_DAYS,
    CANNOT_EDIT_ARCHIVED_CAMPAIGN,
    CANNOT_UPDATE_CONDITION_NOT_TYPE,
    CHANGE_DAY_BUDGET_NOT_MORE_THAN_3_TIMES,
    CHANGE_DISPLAY_REGION_TO,
    CHANGE_REGION_TO_TURKEY,
    CHANGE_REGION_TO_UKRAINE,
    CITY_CODE_NOT_ENTERED,
    CLIENT_IS_ALREADY_USES_OTHER_CURRENCY,
    CONDITION_NOT_TYPE_CAN_USE_ONLY_GOALS,
    CONTACT_INFO_APART_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_APART_INVALID,
    CONTACT_INFO_BUILD_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_BUILD_CONTAINS_INVALID_CHARACTERS,
    CONTACT_INFO_CITY_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_CITY_CODE_REQUIRED,
    CONTACT_INFO_CITY_INVALID,
    CONTACT_INFO_CITY_REQUIRED,
    CONTACT_INFO_COMPANY_NAME_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_COMPANY_NAME_CONTAINS_INVALID_CHARACTERS,
    CONTACT_INFO_COMPANY_NAME_REQUIRED,
    CONTACT_INFO_CONTACT_EMAIL_INVALID,
    CONTACT_INFO_CONTACT_PERSON_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_CONTACT_PERSON_INVALID,
    CONTACT_INFO_COUNTRY_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_COUNTRY_CODE_FORMAT_INVALID,
    CONTACT_INFO_COUNTRY_CODE_MUST_START_FROM,
    CONTACT_INFO_COUNTRY_CODE_REQUIRED,
    CONTACT_INFO_COUNTRY_REQUIRED,
    CONTACT_INFO_EXTRA_MESSAGE_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_EXTRA_MESSAGE_INVALID,
    CONTACT_INFO_HOUSE_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_HOUSE_CONTAINS_INVALID_CHARACTERS,
    CONTACT_INFO_IMCLIENT_INVALID,
    CONTACT_INFO_IMCLIENT_REQUIRED,
    CONTACT_INFO_IMLOGIN_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_IMLOGIN_INVALID,
    CONTACT_INFO_IMLOGIN_INVALID_ICQ,
    CONTACT_INFO_IMLOGIN_INVALID_JABBER,
    CONTACT_INFO_IMLOGIN_INVALID_SKYPE,
    CONTACT_INFO_IMLOGIN_INVALID_MAIL_AGENT,
    CONTACT_INFO_IMLOGIN_REQUIRED,
    CONTACT_INFO_INCORRECT_IMLOGIN,
    CONTACT_INFO_INCORRECT_IMLOGIN_JABBER,
    CONTACT_INFO_INCORRECT_IMLOGIN_SKYPE,
    CONTACT_INFO_INCORRECT_IMLOGIN_MAIL_AGENT,
    CONTACT_INFO_INVALID_COUNTRY_CODE,
    CONTACT_INFO_INVALID_FORMAT_CITY_CODE,
    CONTACT_INFO_INVALID_FORMAT_COUNTRY_CODE,
    CONTACT_INFO_COUNTRY_CODE_WITH_CITY_CODE_SHOULD_NOT_START_WITH_PLUS,
    CONTACT_INFO_INVALID_FORMAT_PHONE,
    CONTACT_INFO_INVALID_FORMAT_PHONE_EXT,
    CONTACT_INFO_LOCATION_CONTAINS_INVALID_CHARACTERS,
    CONTACT_INFO_PHONE_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_PHONE_EXT_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_PHONE_NUMBER_REQUIRED,
    CONTACT_INFO_SHALL_CONTAIN_TOWN,
    CONTACT_INFO_STREET_CHARACTER_LIMIT_EXCEEDED,
    CONTACT_INFO_STREET_CONTAINS_INVALID_CHARACTERS,
    CONTACT_INFO_WORK_TIME_REQUIRED,
    CONTEXT_PRICE_IGNORED,
    CONTEXT_STRANEGY_STRUCTURE_SHOULD_BE_BETWEEN,
    CONTRACT_NOT_FOUND,
    COUNTRY_CODE_NOT_ENTERED,
    COST_PERCENTAGES_SPECIFIED_INCORRECTLY,
    CREATE_BANNER_NO_VALID_CURRENCY_VALUE,
    CREATE_BANNER_VALID_CURRENCY_VALUE_IS,
    CREATE_BANNER_ERROR_IN_PRICE_FIELD_LOW_PRICE,
    CREATE_BANNER_ERROR_IN_PRICE_FIELD_HIGH_PRICE,
    CREATE_CAMPAIGN_IMPOSSIBLE_LOGIN_UNSERVICED,
    CREATE_REPORT_BY_CARRIER_TYPE_AND_BY_MOBILE_PLATFORM_NOT_AVAILABLE,
    CREATEORUPDATEBANNERS_REQUEST_LIMIT_EXCEEDED,
    DAILY_BUDGET_INVALID,
    DAILY_BUDGET_LIMIT,
    DAILY_BUDGET_MINIMUM,
    DAILY_BUDGET_MINIMUM_WITH_CURRENCY,
    DAILY_BUDGET_NOT_ENOUGH_RIGHTS,
    DAILY_BUDGET_TOO_HIGH,
    DAILY_BUDGET_TOO_LOW,
    DATA_IS_AVAILABLE_FOR_THREE_YEARS,
    DAYBUDGETSHOWMODE_INVALID,
    DENIED_TRANSFER_MONEY_BETWEEN_CAMPAIGNS_WITH_DIFFERENT_CURRENCIES,
    DENIED_TRANSFER_MONEY_BETWEEN_WALLETS_WITH_DIFFERENT_CURRENCIES,
    DISALLOW_TRANSFER_MONEY,
    DYNAMIC_FIELD_NAMES_ARRAY_SHOULD_CONTAINS_VALUES,
    EDITING_AN_ARCHIVED_CAMPAIGN_NOT_PERMITTED,
    ENABLE_SHARED_ACCOUNT_REQUIRE_AGENCY_APPROVE,
    ENABLE_SHARED_ACCOUNT_IS_REQUIRED,
    EMPTY_CONTACT_INFO_REQUIRED_FIELDS_ERROR,
    EMPTY_STRING,
    EMPTY_TAGS_NOT_ALLOWED,
    EMPTY_WARNING,
    ENDDATE_FIELD,
    ENDDATE_FIELD_EMPTY,
    ENTER_THE_PARAMETERS_IN_THE_BID_WIZARD,
    ENTIRE_KEYWORD_PHRASES_CANNOT_BE_USED,
    ERROR_IN_BANNER,
    ERROR_IN_CAMPAIGN,
    ERROR_IN_PRICE_FIELD_INVALID_PRICE,
    ERROR_IN_PRICE_FIELD_HIGH_PRICE,
    ERROR_IN_PRICE_FIELD_LOW_PRICE,
    EVENT_TYPES_ARRAY_COULDNT_BE_EMPTY,
    EVENT_TYPES_ARRAY_SHOULD_CONTAINS_VALUES,
    EVENT_TYPES_MUSTBE_ARRAY,
    EQUAL_KEYWORDS_ARE_UNION,
    EXCEEDED_GET_AUCTIONS_LIMIT,
    FIELD,
    FIELD_0_MUST_NOT_BE_EMPTY,
    FIELD_ACTION_FOR_CLIENT,
    FIELD_AGENCY_NAME_MUST_BE_OF_A_STRING_VALUE,
    FIELD_AGENCY_STATUS_MUST_BE_OF_A_STRING_VALUE,
    FIELD_CAMPAIGN_ID_MUST_NOT_BE_EMPTY,
    FIELD_CAMPAIGN_IINVALID,
    FIELD_COMPLETED_INCORRECTLY,
    FIELD_CONTAINS_INVALID_VALUE,
    FIELD_CONTAIN_ONLY_NUMBERS,
    FIELD_COULD_CONTAINS_CHARS,
    FIELD_COULD_CONTAINS_CHARS_NUMBERS,
    FIELD_COULD_CONTAINS_CHARS_NUMBERS_PUNCTUATION,
    FIELD_COULD_CONTAINS_CHARS_NUMBERS_PUNCTUATION_END,
    FIELD_CURRENCY_MUST_CONTAIN_THE_FOLLOWING_VALUE_CU,
    FIELD_CURRENCY_MUST_CONTAIN_THE_FOLLOWING_VALUE,
    FIELD_CURRENCY_MUST_EMPTY_OR_CONTAIN,
    FIELD_CURRENCY_MUST_NOT_BE_EMPTY,
    FIELD_IN_STRUCTURE,
    FIELD_IN_STRUCTURE_SHOULD_BE_UNIQUE,
    FIELD_IS_REQUIRED_FOR_AGENCY,
    FIELD_MUST_BE_NOT_LESS,
    FIELD_MODE_MUST_CONTAIN_FOLLOWING_VALUES_SINGLE_PRICE_WIZARD,
    FIELD_MUST_CONTAIN_VALUE_IN_FORMAT,
    FIELD_MUST_CONTAIN_ENUM_VALUE,
    FIELD_MODE_MUST_NOT_BE_EMPTY,
    FIELD_MUST_BE_A_STRUCTURE,
    FIELD_MUST_BE_FLOAT,
    FIELD_MUST_BE_STRING,
    FIELD_MUST_CONTAIN_FOLLOWING_VALUES,
    FIELD_MUST_NOT_BE_EMPTY,
    FIELD_NOT_FOUND,
    FIELD_NOT_SUPPORTED,
    FIELD_OF_STRUCTURE,
    FIELD_OVERLENGTH,
    FIELD_PARAM1_MAXIMUM_LENGTH_EXCEEDED,
    FIELD_PARAM2_MAXIMUM_LENGTH_EXCEEDED,
    FIELD_PARAM1_MUST_BE_A_STRING,
    FIELD_PAYMETHOD_ALLOWED_VALUE_BANK,
    FIELD_PAYMETHOD_ALLOWED_VALUE_BANK_OVERDRAFT,
    FIELD_PHRASES_MUST_NOT_BE_EMPTY,
    FIELD_POSITION_MUST_CONTAIN_PREMIUM_FIRSTPLACEGUARANTEE_GUARANTEE,
    FIELD_PRICE_BASE_MUST_CONTAIN,
    FIELD_PROC_BASE_MUST_CONTAIN,
    FIELD_PROC_MUST_CONTAIN,
    FIELD_RIGHT_NAME_MUST_CONTAIN_FOLLOWING_VALUES,
    FIELD_SHOULD_BE_A_LOGIN_ARRAY,
    FIELD_SHOULD_BE_A_STRUCTURE_ARRAY,
    FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    FIELD_SHOULD_CONTAIN_A_URL,
    FIELD_SHOULD_CONTAIN_NOT_EMPTY_STRING_OR_NULL,
    FIELD_SHOULD_HAVE_AN_INTEGER_VALUE,
    FIELD_SUBSCRIPTION_RESOURCE_MUST_NOT_BE_EMPTY,
    FIELD_SUBSCRIPTION_TYPE_MUST_NOT_BE_EMPTY,
    FIELD_SUBSCRIPTION_TYPE_SHOULD_CONTAINS_VALUES,
    FIELD_THE_MAXIMUM_PARAMETER_LENGTH_HAS_BEEN_EXCEEDED_BY_CHARACTERS,
    FIELD_TYPE_MUST_CONTAIN_FOLLOWING_VALUE,
    FIELD_TYPE_UPDATE_NOT_PERMISSION,
    FIELD_USERPARAMS_MUST_BE_A_STRUCTURE,
    FIELD_VALUE_MUST_BE_GRATER_OR_EQUAL,
    FIELD_VALUE_SHOULD_BE_MORE_THAN,
    FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
    FIELD_VALUE_SHOULD_NOT_BE_GREATER_THAN,
    FIELDS_NAMES_ARRAY_MUST_CONTAINS,
    FIELD_OF_STRUCTURE_HAS_BEEN_COMPLETED_INCORRECTLY,
    FIELD_MUST_CONTAINS_N_ALPHANUMERIC_CHARS,
    FILTER_CRITERIA_MUST_BE_SPECIFIED,
    FINANCIAL_TOKEN_NOT_SUBMITTED,
    FOR_AGENCY_ONLY,
    FOR_FILTER_BY_SHOULD_BE_SPECIFY_FIELD,
    FORECAST_KEYWORD_PHRASES_INVALID,
    NO_REPORT,
    FORECAST_REPORT_NOT_EXIST,
    FOR_AGENCY_LOGIN_MUST_NOT_BE_EMPTY,
    FUNDS_CANNOT_BE_TRANSFERRED_TO_FROM_MORE_THAN_ONE_CAMPAIGN_AT_A_TIME,
    GEO_COULD_NOT_CONTAINS_ONLY_NEGATIVES,
    GEO_DUPLICATED,
    GEO_EXCLUDED,
    GEO_INCLUDED,
    GEO_NO_REGION_TO_EXCLUDE_FROM,
    GETEVENTSLOG_BANNERIDS_FORMAT_INVALID,
    GETEVENTSLOG_BANNERIDS_MUST_BE_ARRAY,
    GETEVENTSLOG_CAMPAIGNIDS_FORMAT_INVALID,
    GETEVENTSLOG_CAMPAIGNIDS_MUST_BE_ARRAY,
    GETEVENTSLOG_EVENTTYPE_FORMAT_INVALID,
    GETEVENTSLOG_EVENTTYPE_MUST_BE_ARRAY,
    GETEVENTSLOG_PHRASEIDS_FORMAT_INVALID,
    GETEVENTSLOG_PHRASEIDS_MUST_BE_ARRAY,
    GETSUMMARYSTATREQUEST_CAMPAIGNIDS_CANNOT_BE_EMPTY,
    GETSUMMARYSTATREQUEST_CAMPAIGNID_NOT_EXIST,
    GETSUMMARYSTATREQUEST_LIMIT_EXCEEDED,
    GETSUMMARYSTATREQUEST_RESPONSE_ITEMS_EXCEEDED,
    GOAL_NOT_FOUND,
    GROUP_DOES_NOT_EXISTS,
    GROUP_LIMIT_SIZE_EXCEEDED,
    GROUP_DOESNT_EXIST,
    ILLEGAL_SYMBOLS,
    IMAGE_COULD_NOT_BE_UPLOADED_FOR_NO_DIRECT_CLIENT,
    IMAGE_FIELD_MUST_BE_BASE64_ENCODED,
    IMAGE_FILE_UPLOAD_ERROR_404,
    IMAGE_FORMAT_INVALID,
    IMAGE_NOT_FOUND,
    IMAGE_SIZE_INVALID,
    IMAGE_SIZE_INVALID_RU,
    IMPRESSIONS_ON_SITE_CANNOT_BE_DISABLED,
    IMPOSSIBLE_TO_ADD_CONDITION_FOR_NON_CLIENT_USER,
    INCORRECT,
    INCORRECT_DOMAIN_FORMAT,
    INCORRECT_EMAIL_FORMAT,
    INCORRECT_EMAIL_IN_BANNER,
    INCORRECT_FIELD,
    INCORRECT_FILTER_CONDITION_BY_CARRIER_TYPE,
    INCORRECT_FILTER_CONDITION_BY_DEVICE_TYPE,
    INCORRECT_FILTER_CONDITION_BY_MOBILE_PLATFORM,
    INCORRECT_HEADING_OR_DESCRIPTION,
    INCORRECT_LINK,
    INCORRECT_MAXIMUM_BID,
    INCORRECT_SMS_TIME_TO_FIELD,
    INCORRECT_SMS_TIME_FROM_FIELD,
    INCORRECT_USE_OF_SYMBOL_IN_KEYWORD_PHRASE,
    INCORRECT_USE_OF_SYMBOL_IN_MINUS_PHRASE,
    INCORRECT_USE_OF_BRACKETS_IN_MINUS_PHRASE,
    INSUFFICIENT_AMOUNT_ON_ACCOUNT,
    INSUFFICIENT_RIGHTS_FOR_CAMPAIGN,
    INSUFFICIENT_RIGHTS_TRANSFER_MONEY,
    INVALID_ACTION,
    INVALID_AMOUNT_SPECIFIED_FOR_ACCOUNT,
    INVALID_AMOUNT_SPECIFIED_FOR_CAMPAIGN,
    INVALID_BANNER_SETTINGS,
    INVALID_CAMPAIGNS_SPECIFIED,
    INVALID_CITY_CODE_FORMAT,
    INVALID_COST,
    INVALID_COST_PRICE_FIELD,
    INVALID_CURRENCY,
    INVALID_DOMAIN_FORMAT,
    INVALID_FORMAT,
    INVALID_IMAGE_OWNER,
    INVALID_IMCLIENT_TYPE,
    INVALID_PAYMENT_METHOD,
    INVALID_FIELD,
    INVALID_FILTER_IMAGE,
    INVALID_FILE_TYPE,
    INVALID_GEO,
    INVALID_HOLIDAY_SHOW_AND_SHOW_ON_HOLIDAYS_COMBINATION,
    INVALID_JSON_REQUEST,
    INVALID_METRO,
    INVALID_NAME_IN_FIELD_NAMES,
    INVALID_PAYMENT_TOKEN,
    INVALID_PHRASEID,
    INVALID_REPORT_FIELD_NAME_IN_FIELD,
    INVALID_REQUEST_FOR_CAMPAIGNS_IN_DIFFERENT_CURRENCIES,
    INVALID_SUBSCRIPTION_RESOURCE,
    INVALID_TIMETARGET_OR_HOLIDAYSHOW,
    INVALID_USE_PERSISTENT_TOKEN,
    INVALID_USE_OF_FIELD,
    IN_BANNER,
    IN_BANNER_NO_ID,
    IN_BANNER_BANNERID_FIELD_TITLE_MUST_NOT_BE_EMPTY,
    IN_BANNER_BANNER_IN_CAMPAIGN_ARCHIVED,
    IN_BANNER_BANNER_NOT_FOUND,
    IN_BANNER_BANNER_TYPE_NOT_SUPPOTED,
    IN_BANNER_CONTEXT_PRICE_FIELD_VALUE,
    IN_BANNER_FIELD_CONTAINS_INVALID_VALUE,
    IN_BANNER_FIELD_HREF_MUST_BE_OF_A_STRING_VALUE,
    IN_BANNER_FIELD_HREF_MUST_NOT_BE_EMPTY,
    IN_BANNER_FIELD_MUST_BE_OF_A_STRING_VALUE,
    IN_BANNER_FIELD_MUST_NOT_BE_EMPTY,
    IN_BANNER_FIELD_PHRASES_MUST_NOT_BE_EMPTY,
    IN_BANNER_FIELD_TEXT_MUST_NOT_BE_EMPTY,
    IN_BANNER_FIELD_TITLE_MUST_NOT_BE_EMPTY,
    GEOTARGET_CAN_NOT_BE_CHANGED_BECAUSE_UKRAINIAN_TEXT,
    GEOTARGET_CAN_NOT_BE_CHANGED_BECAUSE_TURKEY_TEXT,
    GEOTARGET_CAN_NOT_BE_CHANGED_BECAUSE_KAZAKH_TEXT,
    IN_BANNER_ANY_BID_FIELD_VALUE_LIMIT,
    IN_BANNER_ID_THE_MAXIMUM_STRING_LENGTH_IN_THE_KEYWORD_PHRASE_HAS_BEEN_EXCEEDED,
    IN_BANNER_INCORRECT_BUSINESS_ID,
    IN_BANNER_INCORRECT_LINK,
    IN_BANNER_INCORRECT_WORKING_HOURS,
    IN_BANNER_INVALID_SITELINK,
    IN_BANNER_INVALID_CHARACTER_IN_PARAM1,
    IN_BANNER_INVALID_EXTENSION_NUMBER_FORMAT,
    IN_BANNER_INVALID_NUMBER_FORMAT,
    IN_BANNER_INCORRECT_UID_ICQ,
    IN_BANNER_INCORRECT_UNIQUE_NAME_FOR_INSTANT_MESSENGER_CLIENT,
    IN_BANNER_MAIN_SITE_LINK_MISSING,
    IN_BANNER_MAXIMUM_AD_TEXT_LENGTH_EXCEEDED,
    IN_BANNER_NOT_ALL_QUICK_LINK_FIELDS_COMPLETED,
    IN_BANNER_NO_KEYWORD_PHRASES_SPECIFIED,
    IN_BANNER_PHRASEID,
    IN_BANNER_PLEASE_PROVIDE_YOUR_NAME_OR_COMPANY_NAME,
    IN_BANNER_PLEASE_PROVIDE_YOUR_COUNTRY_NAME,
    IN_BANNER_PLEASE_ENTER_A_COUNTRY_CODE,
    IN_BANNER_PLEASE_PROVIDE_YOUR_CITY_NAME,
    IN_BANNER_PLEASE_ENTER_A_TELEPHONE_NUMBER,
    IN_BANNER_PLEASE_PROVIDE_YOUR_WORKING_HOURS,
    IN_BANNER_PLEASE_ENTER_AN_AREA_CODE,
    IN_BANNER_PRICE_FIELD,
    IN_BANNER_PRICE_FIELD_VALUE,
    IN_BANNER_QUICK_LINKS_CANNOT_LEAD_TO_THE_SAME_WEBPAGE,
    IN_BANNER_QUICK_LINK_TEXTS_CANNOT_BE_THE_SAME,
    IN_BANNER_TITLE_CAN_ONLY_CONTAIN_ONE_TEMPLATE,
    IN_BANNER_TEXT_CAN_ONLY_CONTAIN_ONE_TEMPLATE,
    IN_BANNER_THE_AD_TEXT_CAN_ONLY_CONTAIN_ENGLISH_RUSSIAN_UKRAINIAN_OR_KAZAKH_CHARACTERS_AND_PUNCTUATION_MARKS,
    IN_BANNER_THE_AD_TITLE_CAN_ONLY_CONTAIN_ENGLISH_RUSSIAN_UKRAINIAN_OR_KAZAKH_CHARACTERS_AND_PUNCTUATION_MARKS,
    IN_BANNER_THE_MAXIMUM_LENGTH_OF_KEYWORD_PHRASES_HAS_BEEN_EXCEEDED,
    IN_BANNER_THE_MAXIMUM_QUICK_LINK_LENGTH_HAS_BEEN_EXCEEDED,
    IN_BANNER_N_THE_MAXIMUM_QUICK_LINK_LENGTH_OF_66_CHARACTERS_HAS_BEEN_EXCEEDED,
    IN_BANNER_THE_MAXIMUM_SITELINK_LENGTH_OF_66_CHARACTERS_HAS_BEEN_EXCEEDED,
    IN_BANNER_THE_MAXIMUM_STRING_LENGTH_IN_THE_KEYWORD_PHRASE_HAS_BEEN_EXCEEDED,
    IN_BANNER_SITELINKS_ARRAY_MUST_BE_FROM_1_TO_4_LENGTH_OR_EMPTY,
    IN_BANNER_THE_SITELINKS_ARRAY_MUST_CONTAIN_3_ELEMENTS,
    IN_BANNER_THE_SITELINKS_ARRAY_MUST_CONTAIN_3_ELEMENTS_OR_BE_EMPTY,
    IN_BANNER_THE_VALUE_FIELD_OF_COORDINATE_MUST_BE,
    IN_BANNER_YOU_CAN_ONLY_SPECIFY_ONE_SET_OF_WORKING_HOURS_FOR_EACH_DAY,
    IN_PHRASE,
    IN_PHRASE_CONTEXT_PRICE_FIELD_VALUE,
    IN_PHRASE_PRICE_FIELD_VALUE,
    INCORRECT_RIGHT_STATUS,
    INCORRECT_USE_OF_SYMBOL_IN_START_OR_END_OF_MINUS_PHRASE,
    INVALID,
    INVALID_PHONE_EXTENSION_FORMAT,
    INVALID_SITELINK,
    IS_NOT_YOUR_CAMPAIGN,
    KEYWORDSSUGGESTIONINFO_KEYWORD_LENGTH_EXCEEDED,
    KEYWORDS_ARRAY_MUST_BE_NO_MORE_500,
    KEYWORD_DOESNT_BELONG_TO_LOGIN,
    KEYWORD_DOESNT_BELONG_USER,
    KEYWORD_PHRASES_INVALID,
    KEYWORD_PHRASE_CANNOT_CONSIST_ENTIRELY_OF_STOPWORDS,
    KEYWORD_PHRASE_NOT_ONLY_SPACES,
    WORDSTAT_KEYWORD_PHRASES_INVALID,
    KEYWORD_PHRASE_LENGTH_HAS_BEEN_EXCEEDED,
    KEYWORD_PHRASE_CANNOT_CONTAIN_MORE_THEN_SEVEN_WORDS,
    KEYWORD_PHRASES_NOT_SPECIFIED,
    KEYWORD_PHRASES_REQUIRED,
    LASTEVENTONLY_FIELD,
    LENGTH_OF_MINUS_KEYWORDS_LONGER_THAN,
    LENGTH_OF_BASE64_FIELD_SHOULD_NOT_EXCEED,
    LIGHTUSER_ERROR,
    LIGHT_NOT_ALLOWED_MANAGE_CAMPAIGNS,
    LIMIT_EXCEEDED,
    LINK_HAS_EXCEEDED_CHARACTER_LIMIT,
    LOGINS_FIELD,
    LOGINS_MUST_BE_ARRAY,
    LOGIN_MUST_NOT_BE_EMPTY,
    LOGIN_NOT_FOUND,
    LOGIN_NOT_SWITCHED_ON_TO_DIRECT,
    LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN,
    LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_CUSTOM,
    LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_RUB,
    LOW_AMOUNT_SPECIFIED_FOR_CAMPAIGN_WITH_PLACEHOLDERS,
    LOW_CURRENCY_PAYMENT_AMOUNT,
    LOW_CURRENCY_PAYMENT_AMOUNT_FOR_ACCOUNT,
    LOW_CURRENCY_PAYMENT_AMOUNT_WITHOUT_VAT,
    LOW_FUND_TRANSFERS_FROM,
    LOW_FUND_TRANSFERS_TO,
    LOW_TRANSFER_AMOUNT,
    LOW_TRANSFER_AMOUNT_WITH_PLACEHOLDERS,
    LOWER_MOBILE_BID_PRICE_LIMIT,
    MAXIMUM_AD_FIELD_LENGTH_EXCEEDED,
    MAXIMUM_AD_TEXT_LENGTH_EXCEEDED,
    MAXIMUM_NARROW_SYMBOLS_LENGTH_EXCEEDED,
    MAXIMUM_NUMBER_OF_OBJECTS_REACHED,
    SET_BID_LESS_THAN_MINIMUM,
    METHOD_ALLOWED_CLIENTS_ONLY,
    MINUS_PHRASES_CAN_ONLY_CONSIST,
    MINUS_PHRASES_LENGHT_MORE_THAN,
    MINUS_ONE,
    MINUTES_SHOULD_BE_MULTIPLE_OF_15,
    MOBILE_BID_SHOULD_BE_INTEGER,
    MOBILE_BID_SHOULD_BE_POSITIVE,
    MONEY_TRANSFERS_FROM_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED,
    MONEY_TRANSFERS_TO_SEVERAL_CLIENT_CAMPAIGNS_ARE_NOT_PERMITTED,
    MUST_DELETE_REPORT,
    MUST_SPECIFY_ONLY_ONE_FIELD_CAMPAIGN_ID_BANNER_IDS_LOGINS,
    MUST_SPECIFY_ONLY_ONE_FIELD_CAMPAIGN_ID_BANNER_IDS_PHRASE_IDS,
    MUST_SPECIFY_PARAMETER,
    NECESSARY_CREATE_NEW_CLIENT,
    NEGATIVE_KEYWORDS_ARE_LONGER_THAN_2048_CHARACTERS,
    NEWLOGIN_INVALID,
    NEWREPORTINFO_REPORTID_EMPTY,
    NEWWORDSTATREPORTINFO_INCORRECT_USEOF_MINUS,
    NEWWORDSTATREPORTINFO_INCORRECT_USEOF_PLUS,
    NEWWORDSTATREPORTINFO_INCORRECT_USEOF_SYMBOL,
    NEWWORDSTATREPORTINFO_PHRASES_ALLOWED_SYMBOLS,
    NEWWORDSTATREPORTINFO_PHRASES_CANNOT_BE_EMPTY,
    NEWWORDSTATREPORTINFO_PHRASES_NOT_ONLY_NEGATIVE,
    NEWWORDSTATREPORTINFO_PHRASES_NOT_ONLY_SPACES,
    NEWWORDSTATREPORTINFO_PHRASE_ITEMS_EXCEEDED,
    NO_PHRASES_TO_WHICH_THE_BIDS_CAN_BE_APPLIED,
    NOT_AGENCY_SUB_CLIENT,
    NOT_ALLOWED_ARCHIVE_CAMPAIGN_WITH_MONEY,
    NOT_ALLOWED_DELETE_CAMPAIGN_WITH_MONEY,
    NOT_AN_AGENCY_CLIENT,
    NOT_ENABLE_INVOICE_CAMPAIGN_WITH_DIREFFERENT_CURRENCIES,
    NOT_ENOUGH_FUNDS,
    NOT_ENOUGH_RIGHTS_FOR_LOGIN,
    NOT_ENOUGH_RIGHTS_FOR_OPERATION,
    NO_CAMPAIGN_RIGHT_FOR_LIGHT,
    NO_CREDIT_LIMITS,
    NO_CREDIT_LIMITS_HAVE_BEEN_SET_FOR_THIS_CONTRACT,
    NO_ONE_VALID_LOGIN,
    NO_PAYMENT_TOKEN,
    NO_PERMISSION_TO_CREATE_CLIENTS,
    NO_RIGHTS_FOR_CAMPAIGN,
    NO_RIGTHS_FOR_CLIENT,
    NO_RIGHTS_FOR_SOURCE,
    NO_RIGHTS_FOR_TRANSFER_BETWEEN_AGENCY_CAMPAIGNS,
    NO_RIGHTS_FOR_USE_LOGIN,
    NO_RIGHTS_TO_SHARED_ACCOUNT,
    NO_STATISTICS_FOR_AVERAGE_POSITIONS,
    NO_STATISTICS_FOR_DEVICE_TYPE,
    NO_STATISTICS_FOR_ROI,
    NO_SUCH_DEVICE_OR_ADDRESS,
    NO_VALID_CURRENCY_VALUE,
    NONEXISTENT_LOGINS,
    NULL_STRING,
    NUMBER_OF_DISABLED_SITES_EXCEEDS_ITS_LIMIT,
    ONE_OF_PRICE_CONTEXT_PRICE_AUTOBROKER_FIELD_MUST_BE_SPECIFIED,
    ONE_OF_THE_FIELDS_SINGLEPRICE_CONTEXTPRICE_PRICE_MUST_BE_COMPLETED,
    ONE_OF_THE_FIELDS_SINGLEPRICE_OR_PRICE_MUST_BE_COMPLETED,
    ONE_OF_THE_MAX_PRICE_AVERAGE_PRICE_FIELDS_CAN_BE_COMPLETED,
    ONE_OF_THE_FIELDS_IN_STRUCTURE_MUST_BE_COMPLETED,
    ONE_OF_THE_FOLLOWING_2_FIELDS_MUST_BE_COMPLETED,
    ONE_OF_THE_FOLLOWING_FIELDS_MUST_BE_COMPLETED,
    ONE_OF_THE_FOLLOWING_FIELDS_MUST_NOT_BE_EMPTY,
    ONE_OF_THE_FIELD_MUST_BE_SPECIFIED,
    ON_OF_THE_FOLLOWING_PHRASE_FIELDS_SHOULD_BESPECIFIED,
    ON_OF_THE_FOLLOWING_PHRASE_FIELDS_MUST_BE_COMPLETED,
    ON_OF_THE_FIELDS_KEYWORDS_CAMPAIGNIDS_MUST_BE_COMPLETED,
    ONLY_BANNERIDS_OR_PHRASEIDS_SHOULD_BE_COMPLETED,
    ONLY_THE_ONE_OF_THE_FOLLOWING_FIELDS_IN_STRUCTURE_MUST_BE_COMPLETED,
    OPERATIONS_WITH_SHARED_ACCOUNT_DISABLED,
    ORKTIME_INCORRECT,
    ORKTIME_INCORRECT_MINUTES,
    PAYCAMPELEMENT_CAMPAIGNID_MUST_BE_UNIQUE,
    PAYCAMPELEMENT_SAME_SERVICE_TYPE_NEEDED,
    PAYMENT_AND_TRANSFERRING_TO_ACCOUNT_ARE_PROHIBITED,
    PAYMENT_AND_TRANSFERRING_TO_CAMPAIGN_NOT_PERMITTED,
    PAYMENT_FOR_CAMPAIGN_FORBIDDEN,
    PAYMENT_NOT_PERMITTED_FOR_SEVERAL_USERS,
    PERMISSIBLE_LENGTH_OF_QUICK_LINK,
    PHRASE_ERROR_IN_PRICE_FIELD_LOW_PRICE,
    PHRASE_ERROR_IN_PRICE_FIELD_HIGH_PRICE,
    PHRASEID_NO_VALID_CURRENCY_VALUE,
    PHRASEID,
    PHRASEID_COULD_NOT_FOUND,
    PHRASEIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_2000_ELEMENTS,
    PHRASE_VALID_CURRENCY_VALUE_IS,
    PLEASE_ENTER_A_COUNTRY_CODE,
    PLEASE_ENTER_A_TELEPHONE_NUMBER,
    PLEASE_ENTER_AN_AREA_CODE,
    PHRASE_FILTER_IN_REPORT_OVERLENGTH,
    PLEASE_PROVIDE_CAMPAIGN_S_NAME,
    PLEASE_PROVIDE_EMAIL_ADDRESS_IN_NOTIFICATIONS,
    PLEASE_PROVIDE_LINK_TO_WEBSITE,
    PLEASE_PROVIDE_YOU_NAME,
    PLEASE_PROVIDE_YOUR_NAME_OR_COMPANY_NAME,
    PLEASE_PROVIDE_YOUR_CITY_NAME,
    PLEASE_PROVIDE_YOUR_COUNTRY_NAME,
    PLEASE_PROVIDE_YOUR_WORKING_HOURS,
    PHRASEIDS_FIELD_MUST_BE_AN_ARRAY,
    PHRASEIDS_ARRAY_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    PHRASE_CANT_START_WITH_DOT_OR_APOSTROPHE,
    PHRASE_NOT_FOUND_IN_CAMPAIGN,
    PHRASES_FIELD_SHOULD_NOT_BE_AN_EMPTY_ARRAY,
    PHRASES_FIELD_SHOULD_BE_SPECIFIED,
    PHRASESTYPE_INVALID_VALUE,
    PREVIOUSLY_REPORT_MUST_BE_DELETED,
    PROC_FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
    PROC_SHOULD_NOT_BE_GREATER_THAN_1000,
    QUICK_LINK_TEXT_CAN_ONLY_INCLUDE_ENGLISH_RUSSIAN_UKRAINIAN_OR_KAZAKH_AND_PUNCTUATION_MARKS,
    RAISE_MOBILE_BID_PRICE_LIMIT,
    REGIONIDS_MUSTBE_ARRAY,
    REGION_CANNOT_EXCLUDE_ANYWHERE,
    REGION_KRIM_CANNOT_EXCLUDE_ANYWHERE,
    REGION_KRIM_EXCLUDES_KRIM,
    REGIONS_SPECIFIED_INCORRECTLY,
    REPORT_LIMIT_REACHED,
    REPORT_TYPE_XML_ONLY,
    REPORT_FOR_TYPE_NOT_SUPPORTED,
    RESERVE_RETURN_MUST_BE_MULTIPLES_10,
    RETARGETING_CONDITION_DUPLICATED,
    RETARGETING_CONDITION_GOAL_NUMBER_EXCEEDED,
    RETARGETING_CONDITION_GOALS_NUMBERS_FROM_TO,
    RETARGETING_CONDITION_GROUP_NUMBER_EXCEEDED,
    RETARGETING_CONDITION_IS_USED,
    RETARGETING_CONDITION_NAME_REQUIRED,
    RETARGETING_CONDITION_NUMBERS_FROM_TO,
    RETARGETING_CONDITION_NOT_FOUND,
    RETARGETING_CONDITION_REQUIRED,
    RETARGETING_CONDITION_GROUP_NUMBER_MUST_BE_GREATER_THAN,
    REQUIRED_FIELD,
    ROIOPTIMIZATION_DISABLED,
    REQUEST_LIMIT_EXCEEDED,
    RUBRIC_CANNOT_BE_ADDED,
    RUBRIC_CANNOT_BE_ADDED_NOT_EXISTS,
    SCOPE_FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    SCOPE_FIELD_VALUE_SHOULD_BE_MORE_THAN_0,
    SCOPE_SHOULD_NOT_BE_EMPTY,
    SCOPE_SHOULD_NOT_BE_GREATER_THAN_100,
    SEARCH_CLIENTS_ONE_OF_THE_FOLLOWING_FIELDS_MUST_BE_COMPLETED,
    SEARCH_CLIENT_REQUEST_FILTER_COULD_NOT_BE_EMPTY,
    SEPARATE_INVOICE,
    SET_ROIOPTIMIZATION_NOT_AVAILABLE_FOR_USER,
    SET_STRATEGY_NOT_AVAILABLE_IN_4_VERSION,
    SITELINK_CANNOT_BE_THE_SAME_AS_THE_MAIN_AD_LINK,
    SHOW_ARCHIVE_BANNER_NOT_ALLOWED,
    SOME_FIELD_COMPLETED_INCORRECTLY,
    SOURCE_AD_NOT_FOUND_IN_CAMPAIGN,
    SPECIFIED_BANNER_NOT_EXISTS,
    SPECIFIED_CATEGORY_NOT_EXIST,
    SPECIFIED_KEYWORD_NOT_EXIST,
    STARTDATE_FIELD,
    STARTDATE_FIELD_EMPTY,
    STATPERIOD_SHOULD_BE_NO_MORE_THEN_WEEK,
    STRING_FIELD_SHOULD_NOT_BE_EMPTY,
    STOP_BANNER_BEFORE_OPERATION,
    SUM_EXCEEDED_LIMIT,
    TAGS_LIMIT_FOR_BANNER_EXCEEDED,
    TAGS_NOT_INCLUDED_IN_THE_CAMPAIGN_TAG_LIST,
    TAGS_NUMBER_EXCEEDED,
    TAG_LENGTH_EXCEEDED,
    TELEPHONE_NUMBER_NOT_ENTERED,
    THE_AD_FIELD_CAN_ONLY_CONTAIN_ENGLISH_RUSSIAN_UKRANIAN_CHARACTERS,
    THE_AD_FIELD_CAN_ONLY_CONTAIN_ENGLISH_RUSSIAN_UKRANIAN_KAZAKH_TURKISH_CHARACTERS,
    THE_ARRAY_CANNOT_BE_EMPTY,
    THE_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
    THE_ARRAY_SHOULD_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
    THE_AVERAGE_CPC_CANNOT_BE_MORE_THAN,
    THE_AVERAGE_CPC_MUST_BE_MORE_THAN,
    THE_AVERAGEPRICE_FIELD_FOR_THE_AVERAGECLICKPRICE_STRATEGY_MUST_BE_COMPLETED,
    THE_BANNERIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_N_ELEMENTS,
    THE_BANNERIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_2000_ELEMENTS,
    THE_BANNERIDS_FIELD_MUST_BE_AN_ARRAY,
    THE_BANNERLIST_FIELD_CANNOT_BE_EMPTY,
    THE_BANNERLIST_FIELD_MUST_BE_AN_ARRAY,
    THE_ARRAYOFBANNERINFO_FIELD_MUST_BE_AN_ARRAY,
    THE_BANNER_IDS_ARRAY_CANNOT_BE_EMPTY,
    THE_BID_CANNOT_BE_LESS,
    THE_BID_CANNOT_BE_MORE,
    THE_BUDGET_MUST_BE_ABOVE,
    THE_BUSINESS_ID_YOU_ENTERED_IS_INVALID,
    THE_CAMPAIGNID_FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    THE_CAMPAIGNID_SHOULD_BE_MORE_THAN_ZERO,
    THE_CAMPAIGNIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_10_ELEMENTS,
    THE_CAMPAIGNIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_100_ELEMENTS,
    THE_CAMPAIGNIDS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_500_ELEMENTS,
    THE_CAMPAIGN_DOES_NOT_EXIST,
    THE_CLIENTINFOLIST_FIELD_MUST_BE_AN_ARRAY,
    THE_CPC_CANNOT_BE_GREATER_THAN,
    THE_CPC_CANNOT_BE_LESS_THAN,
    THE_FIELD_IN_STRUCTURE_SMS_NOTIFICATION,
    THE_FIELD_MUST_BE_AN_ARRAY,
    THE_FIELD_PARAMETER_IS_EITHER_NOT_SPECIFIED_OR_NOT_POSITIVE,
    THE_FIELD_OF_THE_STRUCTURE_SHOULD_CONTAIN,
    THE_FIELD_OF_THE_STRUCTURE_SHOULD_BE_BETWEEN,
    THE_FIRST_ONE_OFF_PAYMENT_MUST_BE_AT_LEAST_300_UNITS,
    THE_FIRST_ONE_OFF_PAYMENT_MUST_BE_AT_LEAST_7600_RUB,
    THE_PHRASES_FIELD_SHOULD_BE_SPECIFIED,
    THE_PHRASES_FIELD_MUST_BE_ARRAY,
    THE_PHRASEID_PARAMETER_IS_EITHER_NOT_SPECIFIED_OR_NOT_POSITIVE,
    THE_HOLIDAYSHOWFROM_FIELD_OF_STRUCTURE_HAS_BEEN_COMPLETED_INCORRECTLY,
    THE_HOLIDAYSHOWTO_FIELD_OF_STRUCTURE_HAS_BEEN_COMPLETED_INCORRECTLY,
    THE_INDEPENDENT_MANAGEMENT_OF_SEARCH_STRATEGY_IS_NOT_AVAILABLE,
    THE_IMPRESSION_RIGHT_SEARCH_RESULTS_STRATEGY_IS_NOT_AVAILABLE,
    THE_MAX_PRICE_VALUE,
    THE_MAXIMUM_LENGTH_OF_KEYWORD_PHRASES_HAS_BEEN_EXCEEDED,
    THE_MAXIMUM_QUICK_LINK_LENGTH_OF_66_CHARACTERS_HAS_BEEN_EXCEEDED,
    THE_MAXIMUM_STRING_LENGTH_OF_N_CHARACTERS_IN_THE_KEYWORD_PHRASE,
    THE_NUMBER_OF_CHARACTERS_CANNOT_EXCEED,
    THE_NUMBER_OF_CLICKS_PER_WEEK_SHOULD_NOT_BE_LESS_THAN_100,
    THE_PHRASES_ARRAY_CANNOT_BE_EMPTY,
    THE_SELECTIONCRITERIA_LOGIN_ARRAY_MUST_CONTAIN_NO_MORE_THAN_50_ELEMENTS,
    THE_SEND_ACC_NEWS_FIELD_IN_STRUCTURE_EMAIL_NOTIFICATION,
    THE_SEND_WARN_FIELD_IN_STRUCTURE_EMAIL_NOTIFICATION,
    THE_SITELINKS_ARRAY_MUST_CONTAIN_3_ELEMENTS,
    THE_SITELINKS_ARRAY_MUST_BE_FROM_1_TO_4_LENGTH_OR_EMPTY,
    THE_VALUE_OF_FIELD_MUST_BE_BETWEEN,
    THE_WEEKLY_BUDGET_MUST_BE_GREATER_THAN_THE_AVERAGE_CPA,
    THE_WEEKLY_BUDGET_MUST_BE_GREATER_THAN_THE_MAXIMUM_CPC,
    THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT,
    THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT_WITH_BANNER,
    THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT_WITH_CAMPAIGN,
    THIS_CAMPAIGN_TYPE_DOES_NOT_SUPPORT_WITH_CAMPAIGNS,
    THIS_RETARGETING_CONDITION_CAN_BE_USED_ONLY_FOR_BID_MODIFIERS,
    NOT_ALL_SITELINK_FIELDS_COMPLETED,
    SINGLEPRICE_MUST_BE_A_FLOAT_VALUE,
    SITELINK_TEXTS_CANNOT_BE_THE_SAME,
    SITELINKS_CANNOT_LEAD_TO_THE_SAME_WEBPAGE,
    SITELINK_ADDRESS_NOT_ENTERED,
    SITELINK_TITLE_NOT_ENTERED,
    THE_FIELD_FOR_STRATEGY_MUST_BE_COMPLETED,
    THE_MAXIMUM_AMOUNT_OF_KEYWORDS_EXCEED,
    THE_MAXIMUM_SITELINK_LENGTH_OF,
    THE_TIMEOUT_FIELD_MUST_BE_GREATER_THAN_60,
    THE_TIMEOUT_FIELD_SHOULD_CONTAIN_AN_UNSIGNED_INTEGER_VALUE,
    THE_TRANSFERS_ARRAY_MUST_CONTAIN_NO_MORE_THAN_1_ELEMENTS,
    THE_VALUE_OF_FIELD_MONEY_WARNING_VALUE_IN_STRUCTURE_EMAIL_NOTIFICATION_SHOULD_BE_BETWEEN_1_AND_50,
    THE_WARN_PLACE_INTERVAL_FIELD_IN_STRUCTURE_EMAIL_NOTIFICATION_MUST_CONTAIN_ONE_OF_THE_FOLLOWING_VALUES,
    THE_WEEKLY_BUDGET_MUST_BE_GREATER_THAN_THE_AVERAGE_CPC,
    THE_WEEKLY_BUDGET_MUST_BE_GREATER_THAN_THE_MAXIMUM_BID,
    THE_CLICKS_PER_WEEK_FIELD_FOR_THE_WEEKLYPACKETOFCLICKS_STRATEGY_MUST_BE_COMPLETED,
    THE_WEEKLY_SUM_LIMIT_FIELD_FOR_THE_WEEKLYBUDGET_STRATEGY_MUST_BE_COMPLETED,
    THE_WORD_CANNOT_BE_USED_AS_A_NEGATIVE_IN_THE_ORIGINAL_KEYWORD_PHRASE,
    THERE_ARE_NO_ADS_IN_MEDIA_PLAN,
    THERE_ARE_NO_STATISTICS_FOR_CAMPAIGNS,
    THERE_IS_NOT_ENOUGH_STATISTICAL_CONVERSION_DATA,
    THIS_AD_CANNOT_BE_EDITED_BECAUSE_CAMPAIGN_HAS_BEEN_ARCHIVED,
    THIS_AD_HAS_BEEN_ARCHIVED_AND_CANNOT_BE_EDITED,
    THIS_PHRASE_DOES_NOT_EXIST,
    THIS_TAG_NOT_INCLUDED_IN_THE_CAMPAIGN_TAG_LIST,
    THIS_TAG_IS_ALREADY_BEING_USED,
    TIMESTAMP_FORMAT_ERROR,
    TIMESTAMPFROM_FORMAT_ERROR,
    TIMESTAMPFROM_MUST_NOT_BE_EMPTY,
    TIMESTAMPTO_FORMAT_ERROR,
    TIMESTAMPTO_MUST_NOT_BE_EMPTY,
    TIMEZONE_FIELD_COMPLETED_INCORRECTLY,
    TOTAL_LENGTH_OF_NEGATIVE_KEYWORDS_LONGER_THAN,
    TO_ENABLE_SHARED_ACCOUNT_AT_LEAST_ONE_CAMPAIGN_REQUIRED,
    TRANSFER_CURRENTLY_UNAVAILABLE,
    TRANSFER_FROM_ACCOUNT_ONLY_FOR_AGENCY,
    TRANSFER_ONLY_WITHIN_THE_SAME_AGENCY,
    TRANSFER_WHEN_USING_ACCOUNT,
    TRANSFERMONEY_AMOUNT_NOT_EQUAL,
    TRANSFERMONEY_AMOUNT_NOT_EQUAL_RUS,
    TRANSFERMONEY_BETWEEN_CAMPAIGNS_CLIENT_WITH_ACCOUNT,
    TRANSFERMONEY_BETWEEN_CAMPAIGNS_OF_SAME_ACCOUNT,
    TRANSFERMONEY_INVALID_REMAINING_BALANCE,
    TRANSFERMONEY_INVALID_REMAINING_BALANCE_WITH_CURRENCY,
    TRANSFERMONEY_INVALID_TARGET_CAMPAIGN,
    TRANSFERMONEY_LOW_AMOUNT,
    TRANSFERMONEY_LOW_AMOUNT_TO,
    TRANSFERMONEY_LOW_AMOUNT_TO_WITH_PLACEHOLDERS,
    TRANSFERMONEY_LOW_AMOUNT_WITH_PLACEHOLDERS,
    TRANSFERMONEY_LOW_REMAINING_BALANCE,
    TRANSFERMONEY_NOT_ALL_FIELDS_SPECIFIED,
    TRANSFERMONEY_INVALID_REMAINING_FUNDS,
    TRANSFER_NOT_POSSIBLE,
    TRANSFERMONEY_SUM_NEGATIVE,
    TRANSFERMONEY_SUM_SHALL_BE_FLOAT,
    TRANSFER_OF_FUNDS_FROM_A_CAMPAIGN_BELONGING_TO_AGENCY_CANNOT_BE_DONE,
    TRANSFER_OF_FUNDS_TO_A_CAMPAIGN_BELONGING_TO_AGENCY_CANNOT_BE_DONE,
    TRANSFERS_AMOUNT_SHOULDBE_MORE_THAN_ZERO,
    UNAVAILABLE_CHANGE_CONDITION_NOT_TYPE,
    UNAVAILABLE_CHANGE_CONDITION_ON_NOT_TYPE,
    UNABLE_TO_DELETE_CAMPAIGN,
    UNABLE_TO_PAY_ACCOUNT,
    UNABLE_TO_PERFORM_TRANSACTION_ACCOUNT_HAS_BEEN_ON,
    UNARCHIVE_BANNER_BEFORE,
    UNARCHIVE_CAMPAIGN_BEFORE,
    UNARCHIVE_CURRENCY_CONVERTED_CAMPAIGN,
    UNKNOWN_LANGUAGE,
    UNSUPPORTED_TYPE_OF_IMCLIENT,
    UNABLE_TO_CREATE_AD_CAMPAIGN_HAS_BEEN_ARCHIVED,
    URL_FORMAT_ERROR_DETAILS,
    USER_MUST_BE_A_CLIENT_OF_YANDEX_DIRECT,
    USERS_OF_THE_LI_CANNOT_USE_API,
    COULD_NOT_ALLOW_SUPER_SUPCLIENT_IMPORT_FROM_EXCEL,
    VALID_CURRENCY_VALUE_IS,
    VALUE_OF_RELEVANT_PHRASES_BUDGET_LIMIT_MUST_BE,
    VALUE_OF_THE_FIELD_SHOULD_BE_FROM_0_01_TO_50,
    WORK_WITH_SHARED_ACCOUNT_RESTRICTED,
    WORKING_HOLIDAYS_FIELD,
    WORKTIME_INCORRECT,
    WORKTIME_INCORRECT_MINUTES,
    WRONG_IP_ADDRESS_FORMAT,
    YOU_ARE_NOT_AUTHORIZED_TO_EDIT_THIS_CAMPAIGN,
    YOU_ARE_NOT_AUTHORIZED_TO_USE_THIS_LOGIN,
    YOU_ARE_NOT_AUTHORIZED_TO_VIEW_THE_REQUESTED_INFORMATION,
    YOU_CANNOT_USE_WORDS_OF_SOURCE_KEYWORD_PHRASE_AS_NEGATIVE_KEYWORDS,
    YOU_HAVE_NO_RIGHTS_FOR_THIS_OPERATION,
    YOUR_LOGIN_NOT_SIGN_IN_FOR_DIRECT,
    YOUR_WEEKLY_BUDGET_CANNOT_BE_LESS_THAN,
    YOU_MUST_FILL_REQUEST_AND_WAIT_CONFIRMATION,
    YOU_MUST_SPECIFY_WHETHER_THE_COSTS_OF_PHRASES_AND_CATEGORIES,
    EITHER_LOGINS_EITHER_ACCOUNT_IDS_REQUIRED,
    AGENCY_HAS_NO_RIGHTS_TO_USE_SHARED_ACCOUNT,
    HAS_NO_RIGHTS_TO_EDIT_PARAMS_OF_ACCOUNT_ID,
    HAS_NO_RIGHTS_TO_EDIT_PARAMS_OF_ACCOUNT_ID2,
    THE_FIELD_SHOULD_BE_AN_ARRAY_OF_VALID_USERNAMES,
    REGIONS_ENTERED_INCORRECTLY,
    UNKNOWABLE_FIELD,
    UNABLE_TO_FIND_AGENCY_MANAGER,
    FIELD_LOGIN_CONTAIN_INVALID_CLIENT_LOGIN,
    VALUE_FIELD_NOT_ENTERED,
    VALUE_IN_FIELD_NOT_ENTERED,
    VALUE_ENTERED_IN_INCORRECT_FORMAT,
    INCORRECT_VALUE_ENTERED_IN_FIELD,
    IN_CAMPAIGN_TAGS_LIST_DUPLICATED_TAGS,
    YOU_CAN_ENTER_HOURS_BETWEEN_AND_MINUTES_BETWEEN,
    WORK_TIME_INTERVAL_FORMAT,
    INVALID_IMPRESSIONS_THRESHOLD,
    CLIENT_MUST_ACCEPT_CONVERTATION_OFFER,
    SOMEONE_ELSE_PAYMENT_TOKEN,
    PLEASE_UPDATE_APPLICATION;

    private static String BUNDLE = "api.AxisError";


    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getKey(this);
    }
}
