package ru.yandex.autotests.directapi.apiclient.errors;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 03.08.11
 * Time: 15:12
 * Список ключей к описаниям ошибок.
 * Тексты ошибок содержатся в ресурсах локализации
 *
 * @see /APIAxisErrorMessage
 */
public enum AxisErrorMessage implements ITextResource {
    AN_ERROR_OCCURRED_WHILE_CREATING_CLIENT,
    APPLICATION_NOT_REGISTERED,
    ARRAY_VALUES_INCORRECT,
    INVALID_CAMPAIGN_ID,
    THERE_ARE_NO_STATISTICS_FOR_THIS_CAMPAIGN,
    INVALID_DATE,
    INVALID_TIME_INTERVAL,
    INVALID_LIMITS,
    THIS_FIELD_MUST_BE_AN_ARRAY,
    BAD_BANNER_FILTER,
    BAD_GEO_FILTER,
    BAD_PAGE_NAME_FILTER,
    BAD_PAGE_TYPE_FILTER,
    BAD_PHRASE_FILTER,
    BAD_PAGE_TYPE,
    INVALID_GROUP_BY_DATE_SETTINGS,
    INVALID_REPORT_FIELD,
    INVALID_OFFSET,
    BAD_TYPE_RESULT_REPORT,
    BAD_COMPRESSION_REPORT,
    INVALID_REPORT_ID,
    BAD_BANNER_ID,
    NO_REPORT,
    FIELD_MUST_CONTAIN_THE_FOLLOWING_VALUES_YES_OR_NO,
    FIELD_SET_INCORRECTLY,
    THE_VALUE_MUST_BE_BETWEEN_0_AND_100_IN_MULTIPLE_OF_10,
    INVALID_BANNER_ID,
    INVALID_PHRASE_ID,
    INVALID_CAMPAIGN_TYPE,
    THE_ARRAY_CANNOT_BE_EMPTY,
    REPORT_QUEUE_LIMIT_REACHED,
    BAD_VALUE_FOR_FIELD_POSITION_TYPE,
    INVALID_TIMESTAMP_FORMAT,
    INVALID_STRATEGY_PARAMETERS,
    INVALID_AD_ID,
    INVALID_EMAIL_FORMAT,
    INVALID_FILTER_PARAMETER,
    INVALID_MEDIA_PLAN_AD_ID,
    INVALID_MEDIA_PLAN_KEYWORD_ID,
    INVALID_MEDIA_PLAN_CATEGORY_ID,
    INCORRECT_MEDIA_PLAN,
    INCORRECT_MEDIA_PLAN_AD,
    INVALID_RETARGETING_CONDITION_ID,
    INVALID_AD_GROUP_ID,
    AUTHORIZATION_ERROR,
    NOT_ENOUGH_RIGHTS,
    THIS_METHOD_DOES_NOT_EXIST,
    REQUEST_LIMIT_EXCEEDED,
    INVALID_REQUEST_PARAMETERS,
    INVALID_FORECAST_ID,
    FORECAST_REPORT_NOT_EXIST,
    FORECAST_IS_NOT_READY,
    BAD_CATEGORY_ID,
    INVALID_PHRASE,
    INVALID_GEO_ID,
    INVALID_CATALOG_CATEGORY,
    UNABLE_TO_DELETE_OBJECT,
    THE_SPECIFIED_WORDSTAT_REPORT_DOES_NOT_EXIST,
    INVALID_ARRAY_VALUES,
    INVALID_WORDSTAT_REPORT_ID,
    INVALID_CAMPAIGN_SETTINGS,
    CANNOT_CREATE_CAMPAIGN_IN_BALANCE,
    THE_MAXIMUM_NUMBER_OF_CAMPAIGNS_HAS_BEEN_EXCEEDED,
    INVALID_BANNER_SETTINGS,
    NOT_ENOUGH_UNITS_FOR_CLIENT,
    MAXIMUM_BANNER_LIMIT_EXCEEDED_IN_REQUEST,
    INVALID_POINT_ON_MAP_STRUCTURE,
    THIS_ACTION_CANNOT_BE_PERFORMED_ON_THIS_CAMPAIGN_OR_AD,
    CHANGING_OF_ARCHIVE_CAMPAIGN_OR_BANNER_NOT_ALLOWED,
    LIMIT_ADS_IN_CAMPAIGN_EXCEEDED,
    LIMIT_ADS_IN_GROUP_EXCEEDED,
    THE_CONTEXT_PRICE_FOR_PHRASES_ACTIVE_ON_SEARCH_CANNOT_BE_CHANGED,
    INVALID_NEGATIVE_KEYWORDS,
    MAXIMUM_ARRAY_SIZE_EXCEEDED,
    INVALID_COST,
    BAD_AUTO_BROKER,
    NO_ACCESS,
    NO_PHRASES_FOUND,
    INVALID_CURRENCY,
    INVALID_USER_LOGIN,
    PAY_IN_CURRENCY_NOT_AVAILABLE_FOR_CLIENT,
    LOGIN_IS_OCCUPIED,
    THIS_CLIENT_DOES_NOT_EXIST,
    IMAGE_NOT_FOUND,
    INVALID_IMAGE,
    THE_IMAGE_POOL_SIZE_WAS_EXCEED,
    DOES_NOT_SUPPORT,
    INVALID_FINANCIAL_TRANSACTION_TOKEN,
    INVALID_PAYMENT_METHOD,
    FINANCIAL_TRANSACTIONS_ARE_NOT_PERMITTED_FOR_YOUR_ACCOUNT,
    INVALID_MONEY_TRANSFER_REQUEST,
    INVALID_INVOICE_REQUEST,
    CREDIT_LIMIT_EXCEEDED,
    INVALID_CONTRACT_ID,
    USER_RIGHTS_COULD_NOT_BE_UPDATED,
    PAYMENT_TOKEN_MISSING,
    INVALID_PAYMENT_TOKEN,
    TRANSACTION_DOESNT_EXIST,
    OVERDRAFT_UNAVAILABLE,
    OVERDRAFT_LIMIT_EXCEEDED,
    PAYMENT_OF_DIFF_TYPE_CAMPAIGNS_NOT_ALLOWED,
    UNABLE_TO_PERFORM_TRANSACTION,
    INTERNAL_SERVER_ERROR,
    INVALID_REQUEST,
    API_IS_TEMPORARY_UNAVAILABLE,
    TOO_MANY_SIMULTANEOUS_REQUESTS,
    REQUESTED_API_S_VERSION_IS_NOT_SUPPORTED,
    THIS_METHOD_IS_NOT_AVAILABLE_IN_THIS_API_VERSION,
    ACCESS_DENIED,
    UNKNOWN_LANGUAGE,
    YOUR_LOGIN_IS_NOT_CONNECTED_TO_YANDEX_DIRECT,
    ENABLE_SHARED_ACCOUNT_IS_REQUIRED,
    ENABLE_SHARED_ACCOUNT_HAS_BEEN_ON,
    WORK_WITH_SHARED_ACCOUNT_RESTRICTED,
    NO_CAMPAIGN_WITH_ACCOUNT,
    CAMPAIGN_REQUIRED_TO_ENABLE_SHARED_ACCOUNT,
    NOT_AVAILABLE_SUSPEND_LAST_KEYWORD,
    KEYWORD_NOT_FOUND,
    OVER_LIMIT_KEYWORD_IDS,
    SET_STRATEGY_NOT_AVAILABLE,
    SOMEONE_ELSE_PAYMENT_TOKEN,
    FINANCIAL_TRANSACTIONS_ARE_TEMPORARILY_UNAVAILABLE;

    private static String BUNDLE = "api.AxisErrorMessage";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return TextResources.getKey(this);
    }
}
