package ru.yandex.autotests.directapi.apiclient.errors;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Построение путей аттрибутов для сравнения с путями в ошибках java-direct-api
 * <blockquote><pre>
 *     Path path = Path.path("rules", 1, "goals", 5, "type", "name");
 *     System.out.println(path.toString())
 *     // Rules[1].Goals[5].Type.Name
 * </pre></blockquote>
 */
public class Path {

    private String path;

    public Path(Object... nodes) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;

        for (Object node : nodes) {
            if (node instanceof String) {
                if (!first) {
                    builder.append(".");
                }
                builder.append(capitalize((String) node));
            } else if (node instanceof Integer || node instanceof Long) {
                builder.append("[")
                        .append(node)
                        .append("]");
            }
            first = false;
        }

        this.path = builder.toString();
    }

    public static Path path(Object... nodes) {
        return new Path(nodes);
    }

    @Override
    public String toString() {
        return path;
    }
}
