package ru.yandex.autotests.directapi.apiclient.errors;

import java.util.HashMap;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.TextResourceFormatter;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.DUPLICATE_CATEGORIES_MERGED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.EXISTING_CATALOG_CATEGORY_DELETED_NEW_CATALOG_CATEGORY_CREATED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.EXISTING_CATALOG_CATEGORY_UPDATED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.EXISTING_KEYWORD_DELETED_NEW_KEYWORD_CREATED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.EXISTING_KEYWORD_PHRASE_UPDATED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.EXISTING_RETARGETING_CONDITION_UPDATED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.KEYWORD_ALREADY_STOPPED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.KEYWORD_NOT_STOPPED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.NEW_MEDIA_PLAN_AD_CREATED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.RETARGETING_CONDITION_BID_IGNORED_BECAUSE_OF_AUTOBUDGET;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.RETARGETING_CONDITION_ID_IGNORED;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.RETARGETING_DOESNT_ADDED_GROUP_ALREADY_CONTAINS_IT;
import static ru.yandex.autotests.directapi.apiclient.errors.WarningMessage.SIMILAR_KEYWORDS_MERGED;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 03.08.11
 * Time: 15:12
 * Для части методов в ответе сервиса содержится массив Warning
 * Данный класс является оберткой к объектам такого типа,
 * позволяет сравнивать с ожидаемыми значениями.
 */
public class Warning {
    @SerializedName("WarningCode")
    private int warningCode;

    @SerializedName("WarningString")
    private String warningString;

    @SerializedName("Description")
    private String description;

    public Warning(int warningCode, WarningDescription warnDesc) {
        setWarning(warningCode, warnDesc.toString());
    }

    /**
     * Создает объект Warning с заданным кодом и описанием
     *
     * @param warningCode   код ошибки
     * @param description   ключ-описания ошибки
     * @param detailsParams параметры описания ошибки
     */
    public Warning(int warningCode, AxisErrorDetails description, Object... detailsParams) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(description)
                .args(detailsParams)
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());

        setWarning(warningCode, resourceFormatter.toString());
    }

    private void setWarning(int warningCode, String description) {
        TextResourceFormatter resourceFormatter = TextResourceFormatter.resource(WARNINGS.get(warningCode))
                .locale(DirectTestRunProperties.getInstance().getDirectAPILocale());

        this.warningCode = warningCode;
        this.warningString = resourceFormatter.toString();
        this.description = description;
    }

    public String toString() {
        return JsonUtils.toString(this);
    }

    private Object __equalsCalc = null;

    @Override
    public synchronized boolean equals(Object got) {
        if (!(got instanceof Warning)) {
            return false;
        }
        Warning other = (Warning) got;
        if (got == null) {
            return false;
        }
        if (this == got) {
            return true;
        }
        if (__equalsCalc != null) {
            return (__equalsCalc == got);
        }
        __equalsCalc = got;
        boolean _equals;
        _equals = ((this.warningCode == other.warningCode) &&
                this.warningString.equals(other.warningString) &&
                ((this.description == null && other.description == null) ||
                        (this.description != null &&
                                this.description.replace(" ", "")
                                        .equalsIgnoreCase(
                                                other.description.replace(" ", "").replace("\n", ""))))
        );
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;

    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        _hashCode += warningCode;
        if (warningString != null) {
            _hashCode += warningString.hashCode();
        }
        if (description != null) {
            _hashCode += description.hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }


    /**
     * Список кодов Warnings
     */
    public static final HashMap<Integer, WarningMessage> WARNINGS = new HashMap<Integer, WarningMessage>() {{
        put(201, NEW_MEDIA_PLAN_AD_CREATED);
        put(202, EXISTING_KEYWORD_PHRASE_UPDATED);
        put(203, SIMILAR_KEYWORDS_MERGED);
        put(204, EXISTING_KEYWORD_DELETED_NEW_KEYWORD_CREATED);
        put(205, EXISTING_CATALOG_CATEGORY_UPDATED);
        put(206, DUPLICATE_CATEGORIES_MERGED);
        put(207, EXISTING_CATALOG_CATEGORY_DELETED_NEW_CATALOG_CATEGORY_CREATED);
        put(208, EXISTING_RETARGETING_CONDITION_UPDATED);
        put(209, RETARGETING_CONDITION_BID_IGNORED_BECAUSE_OF_AUTOBUDGET);
        put(210, RETARGETING_DOESNT_ADDED_GROUP_ALREADY_CONTAINS_IT);
        put(211, RETARGETING_CONDITION_ID_IGNORED);
        put(212, KEYWORD_ALREADY_STOPPED);
        put(213, KEYWORD_NOT_STOPPED);
    }};
}



