package ru.yandex.autotests.directapi.apiclient.version4;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;
import ru.yandex.autotests.directapi.model.User;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 16.08.11
 * Time: 13:28
 *
 * @link http://api.yandex.ru/direct/doc/concepts/finance-token.xml
 * Для выполнения финансового метода в заголовке надо передать мастер-токен и номер финансовой операции
 */
public class FinanceHeaderDataProvider {

    private static String masterToken = "";
    private long operationNum;

    public FinanceHeaderDataProvider(User account, String method) {
        new FinanceHeaderDataProvider(account, method, false);
    }

    public FinanceHeaderDataProvider(User account, String method, boolean isSandBox) {
        DirectTestRunProperties properties = DirectTestRunProperties.getInstance();
        String login = account.getLogin();
        DarkSideSteps darkSideSteps = new DarkSideSteps();
        if (isSandBox) {
            masterToken = account.getSandboxToken();
        } else {
            masterToken = (properties.isDirectApiUseDbFinanceToken())
                    ? darkSideSteps.getDirectJooqDbSteps().apiFinanceTokensSteps().getMasterToken(login)
                    : account.getFinanceToken();
        }

        operationNum = generateOperationNum();

        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        } catch (NoSuchAlgorithmException e) {
            throw new DirectAPIException("Ошибка инициализации FinanceHeaderDataProvider", e);
        }
        String forHash = masterToken + operationNum + method + account.getLogin();
        md.update(forHash.getBytes());
        byte[] hash = md.digest();

        //convert the byte to hex format
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02x", b));
        }
        masterToken = sb.toString();
    }

    protected long generateOperationNum() {
        return System.currentTimeMillis();
    }

    public String getMasterToken() {
        return masterToken;
    }

    public long getOperationNum() {
        return operationNum;
    }
}
