package ru.yandex.autotests.directapi.apiclient.version4;

import java.util.Map;

import com.google.gson.annotations.SerializedName;
import org.json.JSONObject;

import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 17.05.13
 * Time: 16:57
 * To change this template use File | Settings | File Templates.
 */
public class JsonRequest {

    @SerializedName("param")
    private Object parameters;

    @SerializedName("method")
    private String method;

    private transient Map<String, Object> header;

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public Object getParameters() {
        return parameters;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return method;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public Map<String, Object> getHeader() {
        return header;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(JsonUtils.toString(header, true));
        builder.deleteCharAt(builder.lastIndexOf("}"));
        builder.append(", \"method\": \"" + method + "\"");
        if (parameters != null) {
            String params;
            if (JSONObject.class.isAssignableFrom(parameters.getClass())) {
                params = parameters.toString();
            } else {
                params = JsonUtils.toString(parameters, false);
            }
            builder.append(", \"param\": " + params);
        }
        builder.append("}");
        String request = builder.toString();
        request = request.replaceAll("\"null\"", "null")
                .replaceAll("\"X\"", "\"x\"")
                .replaceAll("\"X1\"", "\"x1\"")
                .replaceAll("\"X2\"", "\"x2\"")
                .replaceAll("\"Y\"", "\"y\"")
                .replaceAll("\"Y1\"", "\"y1\"")
                .replaceAll("\"Y2\"", "\"y2\"");
        return request;
    }
}
