package ru.yandex.autotests.directapi.apiclient.version5;

import java.util.Map;

import com.google.gson.annotations.SerializedName;

import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;

/**
 * Created by pavryabov on 06.06.16.
 */
public abstract class BaseApiV5Request {

    @SerializedName("params")
    protected Object parameters;

    @SerializedName("method")
    protected String method;

    protected transient Map<String, Object> header;

    public void setParameters(Object parameters) {
        this.parameters = parameters;
    }

    public Object getParameters() {
        return parameters;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return method;
    }

    public void setHeader(Map<String, Object> header) {
        this.header = header;
    }

    public Map<String, Object> getHeader() {
        return header;
    }

    @Override
    public String toString() {
        String request = getRequestAsString();
        request = request.replaceAll("\"null\"", "null");
        return request;
    }

    public abstract String getRequestAsString();

    public abstract ProtocolType getProtocolType();
}
