package ru.yandex.autotests.directapi.apiclient.version5;

import java.lang.reflect.Type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;

public class IntegerDeserializer implements JsonDeserializer<Integer> {

    @Override
    public Integer deserialize(JsonElement jsonElement, Type type,
            JsonDeserializationContext jsonDeserializationContext) throws JsonParseException
    {
        if (jsonElement.equals(new JsonPrimitive("null"))) {
            return null;
        }
        return jsonElement.getAsInt();
    }
}
