package ru.yandex.autotests.directapi.apiclient.version5;

import java.nio.charset.Charset;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

import ru.yandex.autotests.directapi.apiclient.RequestHeader;
import ru.yandex.autotests.directapi.apiclient.config.ConnectionConfig;

public class InvalidJSONClientV5 extends JSONClientV5 {

    public InvalidJSONClientV5(ConnectionConfig connectionConfig,
            RequestHeader requestHeader)
    {
        super(connectionConfig, requestHeader);
    }

    @Override
    protected HttpPost createHttpRequest(String endpoint, JSONRequestV5 request) {
        HttpPost httpRequest = new HttpPost(endpoint);
        StringEntity entity = new StringEntity("test",
                ContentType.create("application/json", Charset.forName("UTF-8")));
        httpRequest.setEntity(entity);
        httpRequest.setHeaders(toHeadersArray(request.getHeader()));
        return httpRequest;
    }
}
