package ru.yandex.autotests.directapi.apiclient.version5;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;

/**
 * Created by chicos on 24.11.14.
 */
public class JSONRequestV5 extends BaseApiV5Request {

    public String getRequestAsString() {
        JsonObject jsonRequest = new JsonObject();
        jsonRequest.addProperty("method", method);
        if (parameters != null) {
            JsonElement params = JsonBuilder.gsonV5.toJsonTree(parameters);
            jsonRequest.add("params", params);
        }
        return JsonBuilder.gsonV5.toJson(jsonRequest);
    }

    @Override
    public ProtocolType getProtocolType() {
        return ProtocolType.JSON;
    }
}
