package ru.yandex.autotests.directapi.apiclient.version5;

import java.lang.reflect.Type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;

/**
 * Created by pavryabov on 12.02.16.
 */
public class LongDeserializer implements JsonDeserializer<Long> {

    @Override
    public Long deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context)
            throws JsonParseException
    {
        if (jsonElement.equals(new JsonPrimitive("null"))) {
            return null;
        }
        return jsonElement.getAsLong();
    }
}
