package ru.yandex.autotests.directapi.apiclient.version5;

/**
 * Created by mariabye on 17.04.14.
 */

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import com.sun.xml.ws.handler.SOAPMessageContextImpl;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import ru.yandex.autotests.directapi.apiclient.HttpMessage;
import ru.yandex.autotests.directapi.steps.LogHandler;
import ru.yandex.qatools.allure.annotations.Attachment;

/*
 * This simple SOAPHandler will output the contents of incoming
 * and outgoing messages.
 */
public class SOAPLoggingHandler implements SOAPHandler<SOAPMessageContext> {
    public static final Log log4j = LogFactory.getLog(SOAPLoggingHandler.class);

    private static HttpMessage message;
    private static HttpMessage originalMessage;

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        logToSystemOut(smc);
        return true;
    }

    public boolean handleFault(SOAPMessageContext smc) {
        logToSystemOut(smc);
        return true;
    }

    // nothing to clean up
    public void close(MessageContext messageContext) {
    }

    @Attachment(value = "[SOAP/CURL]: Request", type = "text/html")
    public String traceHttpMessage(HttpMessage message, HttpMessage originalMessage) {

        Map<String, String> root = new HashMap<>();
        root.put("usualFormatString", message.toString());
        root.put("curlString", originalMessage.toCurlStringForSoap());
        root.put("buttonName", "SOAP");

        String attachmentHTML;
        try {
            TemplateLoader file = new ClassTemplateLoader(this.getClass(), "/");
            Configuration cfg = new Configuration();
            cfg.setTemplateLoader(file);
            cfg.setObjectWrapper(new DefaultObjectWrapper());
            cfg.setDefaultEncoding("UTF-8");
            Template template = cfg.getTemplate("request2curlTemplate.ftl");
            Writer fileWriter = new StringWriter();
            try {
                template.process(root, fileWriter);
            } finally {
                fileWriter.close();
            }
            attachmentHTML = fileWriter.toString();
        } catch (Exception e) {
            throw new RuntimeException("Error", e);
        }

        return attachmentHTML;
    }


    /*
     * Check the MESSAGE_OUTBOUND_PROPERTY in the context
     * to see if this is an outgoing or incoming message.
     * Write a brief message to the print stream and
     * output the message. The writeTo() method can throw
     * SOAPException or IOException
     */
    private void logToSystemOut(SOAPMessageContext smc) {
        Boolean isOutboundMessage = (Boolean) smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (isOutboundMessage) {
            //request
            originalMessage = new HttpMessage();
            originalMessage.setUrl(smc.get(BindingProvider.ENDPOINT_ADDRESS_PROPERTY).toString());
            originalMessage.setHeaders(
                    "-H \"SOAPAction: " + smc.get(SOAPMessageContextImpl.WSDL_OPERATION)
                            .toString().replace("}", "/") + "'\" -H " +
                            smc.get(SOAPMessageContextImpl.HTTP_REQUEST_HEADERS).toString()
            );
            originalMessage.setRequest(LogHandler.getSOAPMessageAsStringForCurl(smc.getMessage()));
            message = new HttpMessage();
            message.setUrl(smc.get(BindingProvider.ENDPOINT_ADDRESS_PROPERTY).toString());
            message.setHeaders(
                    smc.get(SOAPMessageContextImpl.HTTP_REQUEST_HEADERS).toString()
            );
            message.setRequest(LogHandler.getSOAPMessageAsString(smc.getMessage()));
        } else {
            //response
            message.setResponseHeaders(smc.get(SOAPMessageContextImpl.HTTP_RESPONSE_HEADERS).toString());
            message.setResponse(LogHandler.getSOAPMessageAsString(smc.getMessage()));
            message.setStatusCode(smc.get(MessageContext.HTTP_RESPONSE_CODE).toString());
            log4j.trace(message);
            traceHttpMessage(message, originalMessage);
        }
    }
}
