package ru.yandex.autotests.directapi.apiclient.version5;

import com.yandex.direct.api.v5.adextensions.AdExtensionsPort;
import com.yandex.direct.api.v5.adgroups.AdGroupsPort;
import com.yandex.direct.api.v5.adimages.AdImagesPort;
import com.yandex.direct.api.v5.ads.AdsPort;
import com.yandex.direct.api.v5.agencyclients.AgencyClientsPort;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetsPort;
import com.yandex.direct.api.v5.bidmodifiers.BidModifiersPort;
import com.yandex.direct.api.v5.bids.BidsPort;
import com.yandex.direct.api.v5.businesses.BusinessesPort;
import com.yandex.direct.api.v5.campaigns.CampaignsPort;
import com.yandex.direct.api.v5.campaignsext.CampaignsExtPort;
import com.yandex.direct.api.v5.changes.ChangesPort;
import com.yandex.direct.api.v5.clients.ClientsPort;
import com.yandex.direct.api.v5.creatives.CreativesPort;
import com.yandex.direct.api.v5.dictionaries.DictionariesPort;
import com.yandex.direct.api.v5.dynamictextadtargets.DynamicTextAdTargetsPort;
import com.yandex.direct.api.v5.keywordbids.KeywordBidsPort;
import com.yandex.direct.api.v5.keywords.KeywordsPort;
import com.yandex.direct.api.v5.keywordsresearch.KeywordsResearchPort;
import com.yandex.direct.api.v5.leads.LeadsPort;
import com.yandex.direct.api.v5.negativekeywordsharedsets.NegativeKeywordSharedSetsPort;
import com.yandex.direct.api.v5.retargetinglists.RetargetingListsPort;
import com.yandex.direct.api.v5.sitelinks.SitelinksPort;
import com.yandex.direct.api.v5.turbopages.TurboPagesPort;
import com.yandex.direct.api.v5.vcards.VCardsPort;

import java.util.stream.Stream;

/**
 * Created by chicos on 25.11.14.
 */
public enum ServiceNames {

    AD_EXTENSIONS("adextensions", AdExtensionsPort.class),
    AD_GROUPS("adgroups", AdGroupsPort.class),
    AD_IMAGES("adimages", AdImagesPort.class),
    BIDS("bids", BidsPort.class),
    BUSINESSES("businesses", BusinessesPort.class),
    CREATIVES("creatives", CreativesPort.class),
    KEYWORD_BIDS("keywordbids", KeywordBidsPort.class),
    CAMPAIGNS("campaigns", CampaignsPort.class),
    CAMPAIGNS_EXT("campaignsext", CampaignsExtPort.class),
    DICTIONARIES("dictionaries", DictionariesPort.class),
    VCARDS("vcards", VCardsPort.class),
    KEYWORDS("keywords", KeywordsPort.class),
    SITELINKS("sitelinks", SitelinksPort.class),
    ADS("ads", AdsPort.class),
    CHANGES("changes", ChangesPort.class),
    BID_MODIFIERS("bidmodifiers", BidModifiersPort.class),
    DYNAMIC_TEXT_AD_TARGETS("dynamictextadtargets", DynamicTextAdTargetsPort.class),
    REPORTS("reports", null),
    AUDIENCE_TARGETS("audiencetargets", AudienceTargetsPort.class),
    RETARGETING_LISTS("retargetinglists", RetargetingListsPort.class),
    KEYWORDS_RESEARCH("keywordsresearch", KeywordsResearchPort.class),
    CLIENTS("clients", ClientsPort.class),
    AGENCY_CLIENTS("agencyclients", AgencyClientsPort.class),
    LEADS("leads", LeadsPort.class),
    TURBO_PAGES("turbopages", TurboPagesPort.class),
    NEGATIVE_KEYWORD_SHARED_SETS("negativekeywordsharedsets", NegativeKeywordSharedSetsPort.class);

    private final String serviceName;

    private final Class serviceMethods;

    ServiceNames(String action, Class methods) {
        this.serviceName = action;
        this.serviceMethods = methods;
    }

    static ServiceNames fromString(String serviceName) {
        return Stream.of(values())
                .filter(v -> v.serviceName.equalsIgnoreCase(serviceName))
                .findFirst()
                .orElseThrow(IllegalArgumentException::new);
    }

    public Class getMethodsClass() {
        return this.serviceMethods;
    }

    @Override
    public String toString() {
        return this.serviceName;
    }

}
