package ru.yandex.autotests.directapi.apiclient.version5;

import java.lang.reflect.Type;

import javax.xml.bind.annotation.XmlEnumValue;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;

import ru.yandex.autotests.directapi.exceptions.DirectAPIException;

/**
 * Created by chicos on 26.11.2014.
 */
public class XMLBindEnumSerializer implements JsonSerializer<Enum> {
    public XMLBindEnumSerializer() {
    }

    public JsonElement serialize(Enum src, Type typeOfSrc, JsonSerializationContext context) {
        XmlEnumValue annotations;
        try {
            annotations = src.getClass().getField(src.name()).getAnnotation(XmlEnumValue.class);
        } catch (NoSuchFieldException ex) {
            throw new DirectAPIException(
                    "Не удается сериализовать объект " + src.getClass().getSimpleName() + " в JSON, отсутствует поле "
                            + src.name());
        }
        return context.serialize((annotations == null) ? (src.name()) : (annotations.value()));
    }
}
