package ru.yandex.autotests.directapi.apiclient.version5;

import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.exceptions.DirectAPIException;

/**
 * Created by pavryabov on 01.06.16.
 */
public class XMLRequestV5 extends BaseApiV5Request {

    private Class requestType;

    public XMLRequestV5(Class requestType) {
        super();
        this.requestType = requestType;
    }

    public String getRequestAsString() {
        String request;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(requestType);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            StringWriter stringWriter = new StringWriter();
            jaxbMarshaller.marshal(parameters, stringWriter);
            request = stringWriter.toString();
        } catch (JAXBException e) {
            throw new DirectAPIException("Ошибка формирования xml из объекта", e);
        }
        return request;
    }

    @Override
    public ProtocolType getProtocolType() {
        return ProtocolType.XML;
    }
}
