package ru.yandex.autotests.directapi.cases;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * Created by andy-ilyin on 12.09.16.
 */
public final class MinusWordsStorageCases {

    private static final String BEARS_WORD_EN = "bears";
    private static final String BEARS_WORD_RU = "медвежата";

    public static final class TestCase {
        private final String description;
        private final List<String> minusWords;
        private final List<String> normalizedMinusWords;

        private TestCase(String description, String[] minusWords, String[] normalizedMinusWords) {
            this.description = description;
            this.minusWords = Collections.unmodifiableList(Arrays.asList(minusWords));
            this.normalizedMinusWords = Collections.unmodifiableList(Arrays.asList(normalizedMinusWords));
        }

        public String getDescription() {
            return description;
        }

        public List<String> getMinusWords() {
            return minusWords;
        }

        public List<String> getNormalizedMinusWords() {
            return normalizedMinusWords;
        }
    }

    private MinusWordsStorageCases() {
        throw new UnsupportedOperationException("this class is not instantiable");
    }

    public static List<TestCase> getTestCases() {
        return Collections.unmodifiableList(Arrays.asList(
                new TestCase("одно минус-слово латиницей", new String[]{BEARS_WORD_EN}, new String[]{BEARS_WORD_EN}),
                new TestCase("одно минус-слово кириллицей", new String[]{BEARS_WORD_RU}, new String[]{BEARS_WORD_RU}),
                new TestCase("минус-слова со знаками ! и +", new String[]{BEARS_WORD_RU, "+без", "!слонят"},
                        new String[]{BEARS_WORD_RU, "+без", "!слонят"}),
                new TestCase("два ненормализованных минус-слова", new String[]{BEARS_WORD_RU, "медвежат"},
                        new String[]{BEARS_WORD_RU}),
                new TestCase("два минус-слова латиницей", new String[]{BEARS_WORD_EN, "elephants"},
                        new String[]{BEARS_WORD_EN, "elephants"}),
                new TestCase("два минус-слова кириллицей", new String[]{BEARS_WORD_RU, "слоники"},
                        new String[]{BEARS_WORD_RU, "слоники"})

        ));
    }
}
