package ru.yandex.autotests.directapi.converters;

import java.util.Comparator;

/**
 * Created by mariabye on 22.10.14.
 * В Директ минус слова сортируются в лексикографическом порядке с точностью до регистра букв
 */
public class MinusWordsComparator implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        return o1.toLowerCase().compareTo(o2.toLowerCase());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        if (this == null) {
            return obj == null;
        }
        String other = (String) obj;
        return this.equals(other);
    }
}
