package ru.yandex.autotests.directapi.enums;

/**
 * Created by buhter on 30.12.15.
 */
public enum DirectObjectType {

    TEXT(CampaignType.TEXT, AdGroupType.BASE, BannerType.TEXT),
    MOBILE_CONTENT(CampaignType.MOBILE_CONTENT, AdGroupType.MOBILE_CONTENT, BannerType.MOBILE_CONTENT),
    DYNAMIC(CampaignType.DYNAMIC, AdGroupType.DYNAMIC, BannerType.DYNAMIC),
    CPM_BANNER(CampaignType.CPM_BANNER, AdGroupType.CPM_BANNER, BannerType.CPM_BANNER);

    private CampaignType campaignType;
    private AdGroupType adGroupType;
    private BannerType bannerType;

    DirectObjectType(CampaignType campaignType, AdGroupType adGroupType, BannerType bannerType) {
        this.campaignType = campaignType;
        this.adGroupType = adGroupType;
        this.bannerType = bannerType;
    }

    public CampaignType getCampaignType() {
        return campaignType;
    }

    public AdGroupType getAdGroupType() {
        return adGroupType;
    }

    public BannerType getBannerType() {
        return bannerType;
    }

    @Override
    public String toString() {
        return campaignType.toString();
    }
}
