package ru.yandex.autotests.directapi.exceptions;

import org.apache.axis.AxisFault;

import ru.yandex.autotests.directapi.apiclient.errors.AxisError;

/**
 * Created by IntelliJ IDEA.
 * User: mariabye
 * Date: 13.02.12
 * Time: 16:36
 * Exception, выбрасываемый в случае неожиданных ошибок, не связанных
 * непосредственно с тестовым сценарием. Например,
 * ошибки тестовой среды
 * ошибки в тестах
 */
public class DirectAPIException extends RuntimeException {
    String mistake = "Ошибка запроса к сервису";

    public DirectAPIException() {
        super();             // call superclass constructor
        mistake = "unknown";
    }

    public DirectAPIException(String err) {
        super(err);     // call super class constructor
        mistake = err;  // save message
    }

    public DirectAPIException(String message, AxisFault axisFault) {
        super(message + "\n" + new AxisError(axisFault).toString());
    }

    public DirectAPIException(String message, Throwable cause) {
        super(message, cause);
    }
}
