package ru.yandex.autotests.directapi.matchers;

import static org.hamcrest.Matchers.allOf;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 30.12.13
 * Time: 17:43
 * To change this template use File | Settings | File Templates.
 */
public class KeywordMatcher {
    public static <T> org.hamcrest.Matcher<T> hasKeywordWithID(java.lang.String keyword) {
        return allOf(
                hasProperty("keyword", equalTo(keyword)),
                hasProperty("keywordID", not(nullValue()))
        );
    }

    public static <T> org.hamcrest.Matcher<T> hasKeywordWithNoID(java.lang.String keyword) {
        return allOf(
                hasProperty("keyword", equalTo(keyword)),
                hasProperty("keywordID", nullValue())
        );
    }

}
