package ru.yandex.autotests.directapi.matchers.arrays;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

import static org.hamcrest.core.IsEqual.equalTo;

public class ArraySizeMatcher<T> extends TypeSafeMatcher<T[]> {
    private final Matcher<? super Integer> sizeMatcher;

    public ArraySizeMatcher(Matcher<? super Integer> sizeMatcher) {
        this.sizeMatcher = sizeMatcher;
    }

    @Override
    public boolean matchesSafely(T[] ts) {
        return sizeMatcher.matches(ts.length);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("an array with length ");
        sizeMatcher.describeTo(description);
    }

    @Factory
    public static <T> Matcher<T[]> hasSize(Matcher<? super Integer> size) {
        return new ArraySizeMatcher<>(size);
    }

    @Factory
    public static <T> Matcher<T[]> hasSize(int size) {
        return new ArraySizeMatcher<>(equalTo(size));
    }

}
