package ru.yandex.autotests.directapi.matchers.arrays;

import java.util.Arrays;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 08.10.13
 * Time: 12:01
 * To change this template use File | Settings | File Templates.
 */
public class UnsortedArrayMatcher<T> extends TypeSafeMatcher<T[]> {

    private final T[] array;

    public UnsortedArrayMatcher(T[] array) {
        this.array = array;
    }

    @Override
    public boolean matchesSafely(T[] ts) {
        Arrays.sort(ts);
        Arrays.sort(array);
        return new IsEqual(array).matches(ts);
    }


    @Factory
    public static <T> Matcher equalToIgnoreSort(T[] array) {
        return new UnsortedArrayMatcher(array);
    }


    @Override
    public void describeTo(Description description) {
        //To change body of implemented methods use File | Settings | File Templates.
    }
}
