package ru.yandex.autotests.directapi.matchers.axiserror;

import java.util.ArrayList;
import java.util.List;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;

import ru.yandex.autotests.directapi.apiclient.errors.AxisError;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 19.11.12
 * Time: 10:58
 * To change this template use File | Settings | File Templates.
 */
public class ApiResponse extends TypeSafeMatcher<String> {
    private final Matcher elementMatcher;
    protected String jsonPath = ResultJPath.ACTION_RESULT_ERRORS;

    public ApiResponse(Matcher elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    public ApiResponse(Matcher<AxisError> elementMatcher, String jsonPath) {
        this.elementMatcher = elementMatcher;
        this.jsonPath = jsonPath;
    }

    @Override
    public boolean matchesSafely(String array) {
        List<Object> errors =
                JsonPath.read(array, jsonPath);
        for (Object error : errors) {
            if (elementMatcher.matches(new AxisError(error))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        elementMatcher.describeTo(description);
    }

    @org.hamcrest.Factory
    public static Matcher<String> hasError(AxisError error) {
        return ApiResponse.hasErrors(new AxisError[]{error});
    }

    @org.hamcrest.Factory
    public static Matcher<String> hasNoError() {
        return ApiResponseSize.errorsCountEqualTo(0);
    }

    @org.hamcrest.Factory
    public static Matcher<String> hasNoError(String jsonPath) {
        return ApiResponseSize.errorsCountEqualTo(0, jsonPath);
    }

    @Factory
    public static Matcher<String> hasErrors(AxisError... elements) {
        List<Matcher> matchers = new ArrayList<Matcher>();
        for (AxisError element : elements) {
            matchers.add(new ApiResponse(IsEqual.equalTo(element)));
        }
        matchers.add(ApiResponseSize.errorsCountEqualTo(elements.length));
        return new AllOf(matchers);
    }

    @Factory
    public static Matcher<String> hasErrors(String jsonPath, AxisError... elements) {
        List<Matcher> matchers = new ArrayList<Matcher>();
        for (AxisError element : elements) {
            matchers.add(new ApiResponse(IsEqual.equalTo(element), jsonPath));
        }
        return new AllOf(matchers);
    }

    @Factory
    public static Matcher<String> containErrors(AxisError[] elements) {
        List<Matcher> matchers = new ArrayList<Matcher>();
        for (AxisError element : elements) {
            matchers.add(new ApiResponse(IsEqual.equalTo(element)));
        }
        return new AllOf(matchers);
    }


    @Factory
    public static Matcher<String> containError(AxisError error) {
        return ApiResponse.containErrors(new AxisError[]{error});
    }


}
