package ru.yandex.autotests.directapi.matchers.axiserror;

import java.util.List;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 20.11.12
 * Time: 10:23
 * To change this template use File | Settings | File Templates.
 */
public class ApiResponseSize extends TypeSafeMatcher<String> {
    private final Integer size;
    private final String jsonPath;

    public ApiResponseSize(Integer size, String jsonPath) {
        this.size = size;
        this.jsonPath = jsonPath;
    }

    @Override
    public boolean matchesSafely(String json) {
        List<Object> errors =
                JsonPath.read(json, jsonPath);
        return errors.size() == size;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(String.format("Ожидалось, что число %s в ответе = %s", jsonPath, size));
    }

    @org.hamcrest.Factory
    public static <T> org.hamcrest.Matcher<String> errorsCountEqualTo(Integer size) {
        return new ApiResponseSize(size, ResultJPath.ACTION_RESULT_ERRORS);
    }

    @org.hamcrest.Factory
    public static <T> org.hamcrest.Matcher<String> errorsCountEqualTo(Integer size, String jsonPath) {
        return new ApiResponseSize(size, jsonPath);
    }

    @org.hamcrest.Factory
    public static <T> org.hamcrest.Matcher<String> warningsCountEqualTo(Integer size) {
        return new ApiResponseSize(size, ResultJPath.ACTION_RESULT_WARNINGS);
    }
}
