package ru.yandex.autotests.directapi.matchers.axiserror;

import java.util.ArrayList;
import java.util.List;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.AllOf;
import org.hamcrest.core.IsEqual;

import ru.yandex.autotests.directapi.apiclient.errors.Warning;
import ru.yandex.autotests.irt.testutils.json.JsonUtils;

/**
 * Created with IntelliJ IDEA.
 * User: mariabye
 * Date: 19.11.12
 * Time: 10:58
 * To change this template use File | Settings | File Templates.
 */
public class ApiWarning extends TypeSafeMatcher<String> {
    private final Matcher elementMatcher;

    public ApiWarning(Matcher elementMatcher) {
        this.elementMatcher = elementMatcher;
    }

    @Override
    public boolean matchesSafely(String array) {
        List<Object> warnings =
                JsonPath.read(array, ResultJPath.ACTION_RESULT_WARNINGS);
        for (Object error : warnings) {
            Warning warning = JsonUtils.getObject(JsonUtils.toString(error), Warning.class);
            if (elementMatcher.matches(warning)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void describeTo(Description description) {
        elementMatcher.describeTo(description);
    }

    @Factory
    public static Matcher<String> hasWarning(Warning error) {
        return ApiWarning.hasWarnings(error);
    }

    @Factory
    public static Matcher hasNoWarning() {
        return ApiResponseSize.warningsCountEqualTo(0);
    }

    @Factory
    public static Matcher hasWarnings(Warning... elements) {
        List<Matcher> matchers = new ArrayList<Matcher>();
        for (Warning element : elements) {
            matchers.add(new ApiWarning(IsEqual.equalTo(element)));
        }
        matchers.add(ApiResponseSize.warningsCountEqualTo(elements.length));
        return new AllOf(matchers);
    }

    @Factory
    public static Matcher containWarnings(Warning... elements) {
        List<Matcher> matchers = new ArrayList<Matcher>();
        for (Warning element : elements) {
            matchers.add(new ApiWarning(IsEqual.equalTo(element)));
        }
        return new AllOf(matchers);
    }
}
